/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ExprTargetedBlock
extends PropertyExpression<Player, Block> {
    private static final long serialVersionUID = -1829985920300166314L;
    private Expression<Player> players;
    private boolean actualTargetedBlock;
    private static Event last;
    private static final WeakHashMap<Player, Block> targetedBlocks;
    private static long blocksValidForTick;

    static {
        Skript.registerExpression(ExprTargetedBlock.class, Block.class, ExpressionType.NORMAL, "[the] target[ed] block[s] [of %players%]", "%players%'[s] target[ed] block[s]", "[the] actual[ly] target[ed] block[s] [of %players%]", "%players%'[s] actual[ly] target[ed] block[s]");
        last = null;
        targetedBlocks = new WeakHashMap();
        blocksValidForTick = 0L;
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.players = vars[0];
        this.setExpr(this.players);
        this.actualTargetedBlock = matchedPattern >= 2;
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the targeted block" + (this.players.isSingle() ? "" : "s") + " of " + this.players.toString(e, debug);
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    private Block getTargetedBlock(Player p, Event e) {
        if (p == null) {
            return null;
        }
        long time = ((World)Bukkit.getWorlds().get(0)).getFullTime();
        if (last != e || time != blocksValidForTick) {
            targetedBlocks.clear();
            blocksValidForTick = time;
            last = e;
        }
        if (!this.actualTargetedBlock && this.getTime() <= 0 && targetedBlocks.containsKey(p)) {
            return targetedBlocks.get(p);
        }
        Block b = p.getTargetBlock(null, 100);
        if (b.getTypeId() == 0) {
            b = null;
        }
        targetedBlocks.put(p, b);
        return b;
    }

    protected Block[] get(final Event e, Player[] source) {
        return this.get(source, new Converter<Player, Block>(){

            @Override
            public Block convert(Player p) {
                return ExprTargetedBlock.this.getTargetedBlock(p, e);
            }
        });
    }

    @Override
    public Class<Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        super.setTime(time);
        return true;
    }
}

