/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;

public class ExprSignText
extends SimpleExpression<String> {
    private static final long serialVersionUID = -2027328055872524011L;
    private int line;
    private Expression<Block> block;

    static {
        Skript.registerExpression(ExprSignText.class, String.class, ExpressionType.PROPERTY, "[the] line (1\u00a61|2\u00a62|3\u00a63|4\u00a64) [of %block%]", "[the] (1\u00a61st|1\u00a6first|2\u00a62nd|2\u00a6second|3\u00a63rd|3\u00a6third|4\u00a64th|4\u00a6fourth) line [of %block%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.line = parseResult.mark;
        this.block = exprs[0];
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "line " + this.line + " of " + this.block.toString(e, debug);
    }

    protected String[] get(Event e) {
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            return new String[]{((SignChangeEvent)e).getLine(this.line - 1)};
        }
        Block b = this.block.getSingle(e);
        if (b == null) {
            return null;
        }
        if (b.getType() != Material.SIGN_POST && b.getType() != Material.WALL_SIGN) {
            return null;
        }
        return new String[]{((Sign)b.getState()).getLine(this.line - 1)};
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.CLEAR || mode == Changer.ChangeMode.SET) {
            return Skript.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        Block b;
        if (this.getTime() >= 0 && this.block.isDefault() && e instanceof SignChangeEvent && !Delay.isDelayed(e)) {
            switch (mode) {
                case CLEAR: {
                    ((SignChangeEvent)e).setLine(this.line - 1, "");
                    break;
                }
                case SET: {
                    ((SignChangeEvent)e).setLine(this.line - 1, (String)delta);
                }
            }
        }
        if ((b = this.block.getSingle(e)) == null) {
            return;
        }
        if (b.getType() != Material.SIGN_POST && b.getType() != Material.WALL_SIGN) {
            return;
        }
        switch (mode) {
            case CLEAR: {
                ((Sign)b.getState()).setLine(this.line - 1, "");
                break;
            }
            case SET: {
                ((Sign)b.getState()).setLine(this.line - 1, (String)delta);
            }
        }
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, SignChangeEvent.class, this.block);
    }
}

