/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Random;
import org.bukkit.event.Event;

public class ExprRandomNumber
extends SimpleExpression<Number> {
    private static final long serialVersionUID = -9204174109547211339L;
    private Expression<? extends Number> lower;
    private Expression<? extends Number> upper;
    private final Random rand = new Random();
    private boolean integer;

    static {
        Skript.registerExpression(ExprRandomNumber.class, Number.class, ExpressionType.NORMAL, "[a] random (1\u00a6integer|2\u00a6number) (from|between) %number% (to|and) %number%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.lower = exprs[0];
        this.upper = exprs[1];
        this.integer = parser.mark == 1;
        return true;
    }

    protected Number[] get(Event e) {
        Number l = this.lower.getSingle(e);
        Number u = this.upper.getSingle(e);
        if (u == null || l == null) {
            return null;
        }
        if (this.integer) {
            return new Integer[]{(int)(Math.ceil(l.doubleValue()) + (double)this.rand.nextInt((int)(Math.floor(u.doubleValue()) - Math.ceil(l.doubleValue()) + 1.0)))};
        }
        return new Double[]{l.doubleValue() + this.rand.nextDouble() * (u.doubleValue() - l.doubleValue())};
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return this.integer ? Integer.class : Double.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "a random number between " + this.lower + " and " + this.upper;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

