/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class ExprHealth
extends PropertyExpression<LivingEntity, Float> {
    private static final long serialVersionUID = 1795106981005297008L;
    private Expression<LivingEntity> entities;

    static {
        Skript.registerExpression(ExprHealth.class, Float.class, ExpressionType.PROPERTY, "[the] health [of %livingentities%]", "%livingentities%'[s] health");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.entities = vars[0];
        this.setExpr(this.entities);
        return true;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "the health of " + this.entities.toString(e, debug);
    }

    protected Float[] get(Event e, LivingEntity[] source) {
        return this.get(source, new Getter<Float, LivingEntity>(){

            @Override
            public Float get(LivingEntity entity) {
                if (entity.isDead()) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(0.5f * (float)entity.getHealth());
            }
        });
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return Skript.array(Number.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int s = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            s = Math.round(((Number)delta).floatValue() * 2.0f);
        }
        switch (mode) {
            case SET: 
            case CLEAR: {
                LivingEntity[] livingEntityArray = this.entities.getArray(e);
                int n = livingEntityArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LivingEntity entity = livingEntityArray[n2];
                    entity.setHealth(Math2.fit(0, s, entity.getMaxHealth()));
                    ++n2;
                }
                break;
            }
            case ADD: {
                LivingEntity[] livingEntityArray = this.entities.getArray(e);
                int n = livingEntityArray.length;
                int n3 = 0;
                while (n3 < n) {
                    LivingEntity entity = livingEntityArray[n3];
                    entity.setHealth(Math2.fit(0, entity.getHealth() + s, entity.getMaxHealth()));
                    ++n3;
                }
                break;
            }
            case REMOVE: {
                LivingEntity[] livingEntityArray = this.entities.getArray(e);
                int n = livingEntityArray.length;
                int n4 = 0;
                while (n4 < n) {
                    LivingEntity entity = livingEntityArray[n4];
                    entity.setHealth(Math2.fit(0, entity.getHealth() - s, entity.getMaxHealth()));
                    ++n4;
                }
                break;
            }
        }
    }

    @Override
    public Class<Float> getReturnType() {
        return Float.class;
    }
}

