/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ExprFurnaceSlot
extends PropertyExpression<Block, Slot> {
    private static final long serialVersionUID = 4874035145840682702L;
    private static final int ORE = 0;
    private static final int FUEL = 1;
    private static final int RESULT = 2;
    private static final String[] slotNames = new String[]{"ore", "fuel", "result"};
    private Expression<Block> blocks;
    private int slot;

    static {
        Skript.registerExpression(ExprFurnaceSlot.class, Slot.class, ExpressionType.PROPERTY, "[the] ore[s] [slot[s]] of %blocks%", "%block%'[s] ore[s] [slot[s]]", "[the] fuel[s] [slot[s]] of %blocks%", "%block%'[s] fuel[s] [slot[s]]", "[the] result[s] [slot[s]] of %blocks%", "%block%'[s] result[s] [slot[s]]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.blocks = vars[0];
        this.setExpr(this.blocks);
        this.slot = matchedPattern / 2;
        return true;
    }

    protected Slot[] get(Event e, Block[] source) {
        if (this.blocks.isDefault() && (e instanceof FurnaceSmeltEvent || e instanceof FurnaceBurnEvent) && !Delay.isDelayed(e)) {
            Block b = this.blocks.getSingle(e);
            if (b.getType() != Material.FURNACE && b.getType() != Material.BURNING_FURNACE) {
                return null;
            }
            return new Slot[]{new FurnaceEventSlot(e, ((Furnace)b.getState()).getInventory())};
        }
        return this.get(source, new Getter<Slot, Block>(){

            @Override
            public Slot get(Block b) {
                if (b.getType() != Material.FURNACE && b.getType() != Material.BURNING_FURNACE) {
                    return null;
                }
                return new Slot((Inventory)((Furnace)b.getState()).getInventory(), ExprFurnaceSlot.this.slot);
            }
        });
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the " + (this.getTime() == -1 ? "past " : (this.getTime() == 1 ? "future " : "")) + slotNames[this.slot] + " slot of " + this.blocks.toString(e, debug);
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.blocks, FurnaceSmeltEvent.class, FurnaceBurnEvent.class);
    }

    private final class FurnaceEventSlot
    extends Slot {
        private final Event e;

        public FurnaceEventSlot(Event e, FurnaceInventory invi) {
            super((Inventory)invi, ExprFurnaceSlot.this.slot);
            this.e = e;
        }

        @Override
        public ItemStack getItem() {
            if (this.e instanceof FurnaceSmeltEvent) {
                if (ExprFurnaceSlot.this.slot == 2) {
                    if (ExprFurnaceSlot.this.getTime() >= 0) {
                        return ((FurnaceSmeltEvent)this.e).getResult().clone();
                    }
                    return super.getItem();
                }
                if (ExprFurnaceSlot.this.slot == 0) {
                    if (ExprFurnaceSlot.this.getTime() <= 0) {
                        return super.getItem();
                    }
                    ItemStack i = super.getItem();
                    i.setAmount(i.getAmount() - 1);
                    return i.getAmount() == 0 ? new ItemStack(0, 1) : i;
                }
                return super.getItem();
            }
            if (ExprFurnaceSlot.this.slot == 1) {
                if (ExprFurnaceSlot.this.getTime() <= 0) {
                    return super.getItem();
                }
                ItemStack i = super.getItem();
                i.setAmount(i.getAmount() - 1);
                return i.getAmount() == 0 ? new ItemStack(0, 1) : i;
            }
            return super.getItem();
        }

        @Override
        public void setItem(final ItemStack item) {
            if (this.e instanceof FurnaceSmeltEvent) {
                if (ExprFurnaceSlot.this.slot == 2 && ExprFurnaceSlot.this.getTime() >= 0) {
                    if (item == null || item.getTypeId() == 0) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                FurnaceEventSlot.super.setItem(null);
                            }
                        });
                    } else {
                        ((FurnaceSmeltEvent)this.e).setResult(item);
                    }
                } else if (ExprFurnaceSlot.this.slot == 0 && ExprFurnaceSlot.this.getTime() >= 0) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                        @Override
                        public void run() {
                            FurnaceEventSlot.super.setItem(item);
                        }
                    });
                } else {
                    super.setItem(item);
                }
            } else if (ExprFurnaceSlot.this.slot == 1 && ExprFurnaceSlot.this.getTime() >= 0) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        FurnaceEventSlot.super.setItem(item);
                    }
                });
            } else {
                super.setItem(item);
            }
        }
    }
}

