/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

public class ExprEventCancelled
extends SimpleExpression<Boolean> {
    private static final long serialVersionUID = -2280930563562488727L;
    private Kleenean delay;

    static {
        Skript.registerExpression(ExprEventCancelled.class, Boolean.class, ExpressionType.SIMPLE, "[is] event cancelled");
    }

    protected Boolean[] get(Event e) {
        if (!(e instanceof Cancellable)) {
            return null;
        }
        return new Boolean[]{((Cancellable)e).isCancelled()};
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.delay = isDelayed;
        return true;
    }

    @Override
    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "is event cancelled";
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.delay != Kleenean.FALSE) {
            Skript.error("Can't cancel the event anymore after it has already passed");
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.CLEAR) {
            return Skript.array(Boolean.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        if (!(e instanceof Cancellable)) {
            return;
        }
        switch (mode) {
            case CLEAR: {
                ((Cancellable)e).setCancelled(false);
                break;
            }
            case SET: {
                ((Cancellable)e).setCancelled(((Boolean)delta).booleanValue());
            }
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

