/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Slot;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprDurability
extends PropertyExpression<ItemStack, Short> {
    private static final long serialVersionUID = -774982996815756186L;
    private Expression<ItemStack> types;
    private Expression<? extends Slot> slots = null;

    static {
        Skript.registerExpression(ExprDurability.class, Short.class, ExpressionType.PROPERTY, "[the] ((data|damage)[s] [value[s]]|durabilit(y|ies)) of %itemstacks%", "%itemstacks%'[s] ((data|damage)[s] [value[s]]|durabilit(y|ies))");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.types = exprs[0];
        this.setExpr(this.types);
        return true;
    }

    @Override
    public Class<Short> getReturnType() {
        return Short.class;
    }

    protected Short[] get(Event e, ItemStack[] source) {
        return this.get(source, new Converter<ItemStack, Short>(){

            @Override
            public Short convert(ItemStack is) {
                return is.getDurability();
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "data of " + this.types.toString(e, debug);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        SimpleLog log = SkriptLogger.startSubLog();
        this.slots = this.types.getConvertedExpression(Slot.class);
        if (this.slots != null) {
            log.stop();
            return Skript.array(Number.class);
        }
        log.stop();
        if (this.types.isSingle() && Utils.contains(this.types.acceptChange(Changer.ChangeMode.SET), ItemStack.class)) {
            return Skript.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) {
        int a = 0;
        if (mode != Changer.ChangeMode.CLEAR) {
            a = ((Number)delta).intValue();
        }
        switch (mode) {
            case REMOVE: {
                a = -a;
            }
            case ADD: {
                if (this.slots != null) {
                    Slot[] slotArray = this.slots.getArray(e);
                    int n = slotArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Slot slot = slotArray[n2];
                        ItemStack item = slot.getItem();
                        item.setDurability((short)(item.getDurability() + a));
                        slot.setItem(item);
                        ++n2;
                    }
                    break;
                }
                ItemStack is = this.types.getSingle(e);
                if (is == null) {
                    return;
                }
                is.setDurability((short)(is.getDurability() + a));
                this.types.change(e, is, Changer.ChangeMode.SET);
                break;
            }
            case CLEAR: {
                a = 0;
            }
            case SET: {
                if (this.slots != null) {
                    Slot[] slotArray = this.slots.getArray(e);
                    int n = slotArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Slot slot = slotArray[n3];
                        ItemStack item = slot.getItem();
                        item.setDurability((short)a);
                        slot.setItem(item);
                        ++n3;
                    }
                    break;
                }
                ItemStack is = this.types.getSingle(e);
                if (is == null) {
                    return;
                }
                is.setDurability((short)a);
                this.types.change(e, is, Changer.ChangeMode.SET);
            }
        }
    }
}

