/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public class ExprDirection
extends SimpleExpression<Direction> {
    private static final long serialVersionUID = -2703003572226455590L;
    private static final BlockFace[] byMark;
    private Expression<Number> amount;
    private Vector direction;
    private Expression<?> relativeTo;
    boolean horizontal;
    boolean facing;
    private double yaw;

    static {
        Skript.registerExpression(ExprDirection.class, Direction.class, ExpressionType.COMBINED, "[%-number% [(block|meter)[s]] [to the]] (2\u00a6north[(-| |)(6\u00a6east|7\u00a6west)][(ward(s|ly|)|er(n|ly|))] [of]|3\u00a6south[(-| |)(8\u00a6east|9\u00a6west)][(ward(s|ly|)|er(n|ly|))] [of]|(4\u00a6east|5\u00a6west)[(ward(s|ly|)|er(n|ly|))] [of]|0\u00a6above|0\u00a6over|(0\u00a6up|1\u00a6down)[ward(s|ly|)]|1\u00a6below|1\u00a6under[neath]|1\u00a6beneath) [%-direction%]", "[%-number% [(block|meter)[s]]] in [the] (0\u00a6direction|1\u00a6horizontal direction|2\u00a6facing|3\u00a6horizontal facing) of %entity/block% (of|from|)", "[%-number% [(block|meter)[s]]] (0\u00a6in[ ]front [of]|0\u00a6forward[s]|2\u00a6behind|2\u00a6backwards|to the (1\u00a6right|-1\u00a6left) [of])");
        byMark = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.amount = exprs[0];
        switch (matchedPattern) {
            case 0: {
                this.direction = new Vector(byMark[parseResult.mark].getModX(), byMark[parseResult.mark].getModY(), byMark[parseResult.mark].getModZ());
                if (exprs[1] == null) break;
                if (!(exprs[1] instanceof ExprDirection) || ((ExprDirection)exprs[1]).direction == null) {
                    return false;
                }
                this.direction.add(((ExprDirection)exprs[1]).direction);
                break;
            }
            case 1: {
                this.relativeTo = exprs[1];
                this.horizontal = parseResult.mark % 2 != 0;
                this.facing = parseResult.mark >= 2;
                break;
            }
            case 2: {
                this.yaw = 1.5707963267948966 * (double)parseResult.mark;
            }
        }
        return true;
    }

    protected Direction[] get(Event e) {
        Integer n;
        Number number = n = this.amount == null ? (Number)1 : (Number)this.amount.getSingle(e);
        if (n == null) {
            return null;
        }
        if (this.direction != null) {
            return new Direction[]{new Direction(this.direction.clone().multiply(((Number)n).doubleValue()))};
        }
        if (this.relativeTo != null) {
            Object o = this.relativeTo.getSingle(e);
            if (o == null) {
                return null;
            }
            if (o instanceof Block) {
                BlockFace f = Direction.getFacing((Block)o);
                if (f == BlockFace.SELF || this.horizontal && (f == BlockFace.UP || f == BlockFace.DOWN)) {
                    return new Direction[]{Direction.ZERO};
                }
                return new Direction[]{new Direction(f)};
            }
            Location l = ((Entity)o).getLocation();
            if (!this.horizontal && !this.facing) {
                return new Direction[]{new Direction(l.getDirection())};
            }
            double yaw = Direction.yawToRadians(l.getYaw());
            if (this.horizontal && !this.facing) {
                return new Direction[]{new Direction(Math.cos(yaw), 0.0, Math.sin(yaw))};
            }
            double pitch = Direction.pitchToRadians(l.getPitch());
            assert (yaw >= -Math.PI && yaw <= Math.PI);
            assert (pitch > -1.5707963267948966 && pitch < 1.5707963267948966);
            if (!this.horizontal && pitch > 0.7853981633974483) {
                return new Direction[]{new Direction(0.0, 1.0, 0.0)};
            }
            if (!this.horizontal && pitch < -0.7853981633974483) {
                return new Direction[]{new Direction(0.0, -1.0, 0.0)};
            }
            if (yaw > -0.7853981633974483 && yaw < 0.7853981633974483) {
                return new Direction[]{new Direction(1.0, 0.0, 0.0)};
            }
            if (yaw >= 0.7853981633974483 && yaw < 2.356194490192345) {
                return new Direction[]{new Direction(0.0, 0.0, 1.0)};
            }
            if (yaw <= -0.7853981633974483 && yaw > -2.356194490192345) {
                return new Direction[]{new Direction(0.0, 0.0, -1.0)};
            }
            assert (yaw >= 2.356194490192345 && yaw <= -2.356194490192345);
            return new Direction[]{new Direction(-1.0, 0.0, 0.0)};
        }
        return new Direction[]{new Direction(0.0, this.yaw, ((Number)n).doubleValue())};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Direction> getReturnType() {
        return Direction.class;
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.amount == null ? "" : String.valueOf(this.amount.toString(e, debug)) + " ") + (this.direction != null ? Direction.toString(this.direction) : (this.relativeTo != null ? " in " + (this.horizontal ? "horizontal " : "") + (this.facing ? "facing" : "direction") + " of " + this.relativeTo.toString(e, debug) : Direction.toString(0.0, this.yaw, 1.0)));
    }
}

