/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;

public class ExprAttacked
extends SimpleExpression<Entity> {
    private static final long serialVersionUID = 2125171894503017326L;
    private EntityData<?> type;

    static {
        Skript.registerExpression(ExprAttacked.class, Entity.class, ExpressionType.SIMPLE, "[the] (attacked|damaged|victim) [<(.+)>]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        String type;
        if (!Utils.containsAny(ScriptLoader.currentEvents, EntityDamageEvent.class, EntityDamageByBlockEvent.class, EntityDamageByEntityEvent.class, EntityDeathEvent.class)) {
            Skript.error("Cannot use 'damaged'/'victim' outside of a damage or death event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        String string = type = parser.regexes.size() == 0 ? null : parser.regexes.get(0).group();
        if (type == null) {
            this.type = EntityData.fromClass(Entity.class);
        } else {
            this.type = EntityData.parse(type);
            if (this.type == null) {
                Skript.error("'" + type + "' is not an entity type", ErrorQuality.NOT_AN_EXPRESSION);
                return false;
            }
        }
        return true;
    }

    protected Entity[] get(Event e) {
        Entity[] one = (Entity[])Array.newInstance(this.type.getType(), 1);
        Entity entity = Utils.validate(((EntityEvent)e).getEntity());
        if (this.type.isInstance(entity)) {
            one[0] = entity;
            return one;
        }
        return null;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type.getType();
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e == null) {
            return "the attacked " + this.type;
        }
        return Classes.getDebugMessage(this.getSingle(e));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean getAnd() {
        return true;
    }
}

