/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class EvtItem
extends SkriptEvent {
    private static final long serialVersionUID = 4903912508088708449L;
    private Literal<ItemType> types;

    static {
        Skript.registerEvent(EvtItem.class, BlockDispenseEvent.class, "dispense [[of] %itemtypes%]");
        Skript.registerEvent(EvtItem.class, ItemSpawnEvent.class, "item spawn [[of] %itemtypes%]");
        Skript.registerEvent(EvtItem.class, PlayerDropItemEvent.class, "drop [[of] %itemtypes%]");
        Skript.registerEvent(EvtItem.class, CraftItemEvent.class, "craft [[of] %itemtypes%]");
        Skript.registerEvent(EvtItem.class, PlayerPickupItemEvent.class, "(pickup|picking up) [[of] %itemtypes%]");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.types = args[0];
        return true;
    }

    @Override
    public boolean check(Event e) {
        ItemStack is;
        if (this.types == null) {
            return true;
        }
        if (e instanceof BlockDispenseEvent) {
            is = ((BlockDispenseEvent)e).getItem();
        } else if (e instanceof ItemSpawnEvent) {
            is = ((ItemSpawnEvent)e).getEntity().getItemStack();
        } else if (e instanceof PlayerDropItemEvent) {
            is = ((PlayerDropItemEvent)e).getItemDrop().getItemStack();
        } else if (e instanceof CraftItemEvent) {
            is = ((CraftItemEvent)e).getRecipe().getResult();
        } else if (e instanceof PlayerPickupItemEvent) {
            is = ((PlayerPickupItemEvent)e).getItem().getItemStack();
        } else {
            throw new IllegalStateException();
        }
        return this.types.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(is);
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "dispense/spawn/drop/craft/pickup" + (this.types == null ? "" : " of " + this.types);
    }
}

