/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import java.io.Serializable;
import org.bukkit.entity.Entity;

public class EntityType
implements Serializable {
    private static final long serialVersionUID = 7309746195257258341L;
    public int amount = -1;
    public final EntityData<?> data;

    static {
        Classes.registerClass(new ClassInfo<EntityType>(EntityType.class, "entitytype", "entity type").defaultExpression(new SimpleLiteral<EntityType>(new EntityType(Entity.class, 1), true)).parser(new Parser<EntityType>(){

            @Override
            public EntityType parse(String s, ParseContext context) {
                return EntityType.parse(s);
            }

            @Override
            public String toString(EntityType t) {
                return t.toString();
            }

            @Override
            public String toVariableNameString(EntityType t) {
                return "entitytype:" + t.toString();
            }

            @Override
            public String getVariableNamePattern() {
                return "entitytype:.+";
            }
        }).serializer(new Serializer<EntityType>(){

            @Override
            public String serialize(EntityType t) {
                return String.valueOf(t.amount) + "*" + t.data.serialize();
            }

            @Override
            public EntityType deserialize(String s) {
                String[] split = s.split("\\*");
                if (split.length != 2) {
                    return null;
                }
                EntityData d = EntityData.serializer.deserialize(split[1]);
                if (d == null) {
                    return null;
                }
                try {
                    return new EntityType(d, Integer.parseInt(split[1]));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }));
    }

    public EntityType(EntityData<?> data, int amount) {
        assert (data != null);
        this.data = data;
        this.amount = amount;
    }

    public EntityType(Class<? extends Entity> c, int amount) {
        assert (c != null);
        this.data = EntityData.fromClass(c);
        this.amount = amount;
    }

    public EntityType(Entity e) {
        this.data = EntityData.fromEntity(e);
    }

    public boolean isInstance(Entity entity) {
        return this.data.isInstance(entity);
    }

    public String toString() {
        return this.getAmount() == 1 ? this.data.toString() : String.valueOf(this.amount) + " " + Utils.toPlural(this.data.toString());
    }

    public int getAmount() {
        return this.amount == -1 ? 1 : this.amount;
    }

    public boolean sameType(EntityType other) {
        if (other == null) {
            return false;
        }
        return this.data.equals(other.data);
    }

    public static EntityType parse(String s) {
        assert (s != null && s.length() != 0);
        int amount = -1;
        if (s.matches("\\d+ .+")) {
            amount = Skript.parseInt(s.split(" ", 2)[0]);
            s = s.split(" ", 2)[1];
        } else if (s.matches("(?i)an? .+")) {
            s = s.split(" ", 2)[1];
        }
        EntityData<?> data = EntityData.parseWithoutAnOrAny(s);
        if (data == null) {
            return null;
        }
        return new EntityType(data, amount);
    }
}

