/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Direction;
import ch.njol.util.Kleenean;
import org.bukkit.Location;
import org.bukkit.event.Event;

public class EffExplosion
extends Effect {
    private static final long serialVersionUID = -8064905811905989142L;
    private Expression<Number> force;
    private Expression<Location> locations;

    static {
        Skript.registerEffect(EffExplosion.class, "[create] [an] explosion (of|with) (force|strength|power) %number% [%directions% %locations%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.force = exprs[0];
        this.locations = Direction.combine(exprs[1], exprs[2]);
        return true;
    }

    @Override
    public void execute(Event e) {
        Number power = this.force.getSingle(e);
        if (power == null) {
            return;
        }
        Location[] locationArray = this.locations.getArray(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            l.getWorld().createExplosion(l, power.floatValue());
            ++n2;
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "create explosion of force " + this.force.toString(e, debug) + " " + this.locations.toString(e, debug);
    }
}

