/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;

public class EffChange
extends Effect {
    private static final long serialVersionUID = 5756451063750867855L;
    private static Patterns<Changer.ChangeMode> patterns = new Patterns(new Object[][]{{"(add|give) %objects% to %objects%", Changer.ChangeMode.ADD}, {"increase %objects% by %objects%", Changer.ChangeMode.ADD}, {"give %objects% %objects%", Changer.ChangeMode.ADD}, {"set %objects% to %objects%", Changer.ChangeMode.SET}, {"(remove|subtract) %objects% from %objects%", Changer.ChangeMode.REMOVE}, {"(clear|delete) %objects%", Changer.ChangeMode.CLEAR}});
    private Expression<?> changed;
    private Expression<?> changer = null;
    private Changer.ChangeMode mode;
    private boolean single = true;
    private Changer<?, ?> c = null;

    static {
        Skript.registerEffect(EffChange.class, patterns.getPatterns());
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        boolean hasError;
        this.mode = patterns.getInfo(matchedPattern);
        switch (this.mode) {
            case ADD: {
                if (matchedPattern == 0) {
                    this.changer = vars[0];
                    this.changed = vars[1];
                    break;
                }
                this.changed = vars[0];
                this.changer = vars[1];
                break;
            }
            case SET: {
                this.changer = vars[1];
                this.changed = vars[0];
                break;
            }
            case REMOVE: {
                this.changer = vars[0];
                this.changed = vars[1];
                break;
            }
            case CLEAR: {
                this.changed = vars[0];
            }
        }
        if (this.changed instanceof Literal) {
            return false;
        }
        int e = SkriptLogger.getNumErrors();
        Class<?>[] rs = this.changed.acceptChange(this.mode);
        boolean bl = hasError = SkriptLogger.getNumErrors() != e;
        if (rs == null) {
            ClassInfo<?> ci = Classes.getSuperClassInfo(this.changed.getReturnType());
            if (ci == null || ci.getChanger() == null || ci.getChanger().acceptChange(this.mode) == null) {
                if (hasError) {
                    return false;
                }
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can't be set", ErrorQuality.SEMANTIC_ERROR);
                } else if (this.mode == Changer.ChangeMode.CLEAR) {
                    Skript.error(this.changed + " can't be cleared/deleted", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error(this.changed + " can't have anything " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " it", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
            this.c = ci.getChanger();
            rs = this.c.acceptChange(this.mode);
        }
        if (this.changer != null) {
            Class[] r;
            ErrorQuality q = this.changer.getReturnType() == Object.class ? ErrorQuality.NOT_AN_EXPRESSION : ErrorQuality.SEMANTIC_ERROR;
            SimpleLog log = SkriptLogger.startSubLog();
            Expression v = null;
            Class[] x = null;
            Class<?>[] classArray = rs;
            int n = rs.length;
            int n2 = 0;
            while (n2 < n) {
                r = classArray[n2];
                v = this.changer.getConvertedExpression(r.isArray() ? r.getComponentType() : r);
                if (v != null) {
                    x = r;
                    break;
                }
                ++n2;
            }
            log.stop();
            if (v == null) {
                if (log.hasErrors()) {
                    SkriptLogger.log(log.getFirstError());
                    return false;
                }
                r = new Class[rs.length];
                int i = 0;
                while (i < rs.length) {
                    r[i] = rs[i].isArray() ? rs[i].getComponentType() : rs[i];
                    ++i;
                }
                if (rs.length == 1 && rs[0] == Object.class) {
                    Skript.error("Can't understand this expression: " + this.changer, ErrorQuality.NOT_AN_EXPRESSION);
                } else if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can't be set to " + this.changer + " because the latter is " + SkriptParser.notOfType(r), q);
                } else {
                    Skript.error(this.changer + " can't be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + " because the former is " + SkriptParser.notOfType(r), q);
                }
                return false;
            }
            if (x.isArray()) {
                this.single = false;
                x = x.getComponentType();
            }
            this.changer = v;
            if (!this.changer.isSingle() && this.single) {
                if (this.mode == Changer.ChangeMode.SET) {
                    Skript.error(this.changed + " can only be set to one " + Classes.getSuperClassInfo(x).getName() + ", but multiple are given", ErrorQuality.SEMANTIC_ERROR);
                } else {
                    Skript.error("only one " + Classes.getSuperClassInfo(x).getName() + " can be " + (this.mode == Changer.ChangeMode.ADD ? "added to" : "removed from") + " " + this.changed + ", but multiple are given", ErrorQuality.SEMANTIC_ERROR);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected void execute(Event e) {
        if (this.c != null) {
            Changer.ChangerUtils.change(this.c, this.changed.getArray(e), this.changer == null ? null : (this.single ? (?[])this.changer.getSingle(e) : this.changer.getArray(e)), this.mode);
        } else {
            this.changed.change(e, this.changer == null ? null : (this.single ? (?[])this.changer.getSingle(e) : this.changer.getArray(e)), this.mode);
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        switch (this.mode) {
            case ADD: {
                return "add " + this.changer.toString(e, debug) + " to " + this.changed.toString(null, true);
            }
            case CLEAR: {
                return "clear " + this.changed.toString(null, true);
            }
            case REMOVE: {
                return "remove " + this.changer.toString(e, debug) + " from " + this.changed.toString(null, true);
            }
            case SET: {
                return "set " + this.changed.toString(e, debug) + " to " + this.changer.toString(null, true);
            }
        }
        throw new IllegalStateException();
    }
}

