/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.WeatherType;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.WeatherEvent;

public class CondWeather
extends Condition {
    private static final long serialVersionUID = 364874019960153313L;
    private Expression<WeatherType> weathers;
    private Expression<World> worlds;

    static {
        Skript.registerCondition(CondWeather.class, "is %weathertypes% [in %worlds%]");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.weathers = vars[0];
        this.worlds = vars[1];
        return true;
    }

    @Override
    public boolean check(final Event e) {
        if (this.worlds.isDefault() && e instanceof WeatherEvent && !Delay.isDelayed(e)) {
            return this.weathers.check(e, new Checker<WeatherType>(){

                @Override
                public boolean check(WeatherType t) {
                    return t == WeatherType.fromEvent((WeatherEvent)e);
                }
            }, this.isNegated());
        }
        return this.weathers.check(e, new Checker<WeatherType>(){

            @Override
            public boolean check(final WeatherType wt) {
                return CondWeather.this.worlds.check(e, new Checker<World>(){

                    @Override
                    public boolean check(World w) {
                        return wt.isWeather(w);
                    }
                }, CondWeather.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "is " + this.weathers.toString(e, debug) + " in " + this.worlds.toString(e, debug);
    }
}

