/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

public class CondPermission
extends Condition {
    private static final long serialVersionUID = 5480435441737985507L;
    private Expression<String> permissions;
    private Expression<CommandSender> senders;

    static {
        Skript.registerCondition(CondPermission.class, "[%commandsenders%] (do[es]n't|don't|do[es] not) have [the] permission[s] %strings%", "[%commandsenders%] ha(s|ve) [the] permission[s] %strings%");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.senders = vars[0];
        this.permissions = vars[1];
        this.setNegated(matchedPattern == 0);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.senders.check(e, new Checker<CommandSender>(){

            @Override
            public boolean check(final CommandSender s) {
                return CondPermission.this.permissions.check(e, new Checker<String>(){

                    @Override
                    public boolean check(String perm) {
                        if (s.hasPermission(perm)) {
                            return true;
                        }
                        if (perm.startsWith("skript.")) {
                            int i = perm.lastIndexOf(46);
                            while (i != -1) {
                                if (s.hasPermission(String.valueOf(perm.substring(0, i + 1)) + "*")) {
                                    return true;
                                }
                                i = perm.lastIndexOf(46, i - 1);
                            }
                        }
                        return false;
                    }
                }, CondPermission.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.senders.toString(e, debug)) + " " + (this.isNegated() ? "doesn't have" : "has") + " the permission " + this.permissions.toString(e, debug);
    }
}

