/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CondIsBanned
extends Condition {
    private static final long serialVersionUID = -2253265799057608926L;
    private Expression<?> players;
    boolean ipBanned;

    static {
        Skript.registerCondition(CondIsBanned.class, "%offlineplayers/strings% (is|are) banned", "%players/strings% (is|are) IP(-| |)banned", "%offlineplayers/strings% (isn't|is not|aren't|are not) banned", "%players/strings% (isn't|is not|aren't|are not) IP(-| |)banned");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.setNegated(matchedPattern >= 2);
        this.ipBanned = matchedPattern % 2 != 0;
        return true;
    }

    @Override
    public boolean check(Event e) {
        return this.players.check(e, new Checker<Object>(){

            @Override
            public boolean check(Object o) {
                if (o instanceof Player) {
                    if (CondIsBanned.this.ipBanned) {
                        return Bukkit.getIPBans().contains(((Player)o).getAddress().getAddress().getHostAddress());
                    }
                    return ((Player)o).isBanned();
                }
                if (o instanceof OfflinePlayer) {
                    return ((OfflinePlayer)o).isBanned();
                }
                if (o instanceof String) {
                    return Bukkit.getIPBans().contains(o) || Bukkit.getOfflinePlayer((String)((String)o)).isBanned();
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return false;
            }
        }, this.isNegated());
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.players.toString(e, debug)) + (this.players.isSingle() ? " is " : " are ") + (this.isNegated() ? "not " : "") + "banned";
    }
}

