/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CondInventoryContains
extends Condition {
    private static final long serialVersionUID = -5748739007049607102L;
    private Expression<?> invis;
    private Expression<?> items;

    static {
        Skript.registerCondition(CondInventoryContains.class, "%inventories% ha(s|ve) %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings% contain[s] %itemtypes/strings%", "%inventories% do[es](n't| not) have %itemtypes% [in [(the[ir]|his|her|its)] inventory]", "%inventories/strings% do[es](n't| not) contain %itemtypes/strings%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.invis = exprs[0];
        this.items = exprs[1];
        this.setNegated(matchedPattern >= 2);
        return true;
    }

    @Override
    public boolean check(final Event e) {
        return this.invis.check(e, new Checker<Object>(){

            @Override
            public boolean check(Object invi) {
                if (invi instanceof Inventory) {
                    final ItemStack[] buf = ((Inventory)invi).getContents();
                    return CondInventoryContains.this.items.check(e, new Checker<Object>(){

                        @Override
                        public boolean check(Object type) {
                            return type instanceof ItemType && ((ItemType)type).isContainedIn(buf);
                        }
                    }, CondInventoryContains.this.isNegated());
                }
                final String s = ((String)invi).toLowerCase();
                return CondInventoryContains.this.items.check(e, new Checker<Object>(){

                    @Override
                    public boolean check(Object type) {
                        return type instanceof String && s.contains(((String)type).toLowerCase());
                    }
                }, CondInventoryContains.this.isNegated());
            }
        });
    }

    @Override
    public String toString(Event e, boolean debug) {
        return String.valueOf(this.invis.toString(e, debug)) + (this.isNegated() ? " doesn't have " : " has ") + this.items.toString(e, debug);
    }
}

