/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.command;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.help.HelpMap;
import org.bukkit.help.HelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public abstract class Commands {
    private static final Map<String, ScriptCommand> commands = new HashMap<String, ScriptCommand>();
    private static SimpleCommandMap commandMap = null;
    private static Map<String, Command> cmKnownCommands;
    private static Set<String> cmAliases;
    private static final SectionValidator commandStructure;
    public static List<Argument<?>> currentArguments;
    private static final String escape;
    private static final Listener commandListener;
    private static boolean suppressUnknownCommandMessage;
    private static final Listener pre1_3chatListener;
    private static final Listener post1_3chatListener;
    private static boolean registeredListener;

    static {
        try {
            if (Bukkit.getPluginManager() instanceof SimplePluginManager) {
                Field commandMapField = SimplePluginManager.class.getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                commandMap = (SimpleCommandMap)commandMapField.get(Bukkit.getPluginManager());
                Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                cmKnownCommands = (Map)knownCommandsField.get(commandMap);
                Field aliasesField = SimpleCommandMap.class.getDeclaredField("aliases");
                aliasesField.setAccessible(true);
                cmAliases = (Set)aliasesField.get(commandMap);
            }
        }
        catch (SecurityException e) {
            Skript.error("Please disable the security manager");
            commandMap = null;
        }
        catch (Exception e) {
            Skript.outdatedError(e);
            commandMap = null;
        }
        commandStructure = new SectionValidator().addEntry("usage", true).addEntry("description", true).addEntry("permission", true).addEntry("permission message", true).addEntry("aliases", true).addEntry("executable by", true).addSection("trigger", false);
        currentArguments = null;
        escape = Pattern.quote("(|)<>%\\");
        commandListener = new Listener(){

            @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
            public void onPlayerCommand(PlayerCommandPreprocessEvent e) {
                if (Commands.handleCommand((CommandSender)e.getPlayer(), e.getMessage().substring(1))) {
                    e.setCancelled(true);
                }
            }

            @EventHandler(priority=EventPriority.LOW)
            public void onServerCommand(ServerCommandEvent e) {
                if (e.getCommand() == null || e.getCommand().isEmpty()) {
                    return;
                }
                if (SkriptConfig.enableEffectCommands && e.getCommand().startsWith(SkriptConfig.effectCommandToken)) {
                    if (Commands.handleEffectCommand(e.getSender(), e.getCommand())) {
                        e.setCommand("");
                        suppressUnknownCommandMessage = true;
                    }
                    return;
                }
                if (Commands.handleCommand(e.getSender(), e.getCommand())) {
                    e.setCommand("");
                    suppressUnknownCommandMessage = true;
                }
            }
        };
        suppressUnknownCommandMessage = false;
        Bukkit.getLogger().addHandler(new Handler(){

            @Override
            public void publish(LogRecord lr) {
                if (suppressUnknownCommandMessage && lr.getMessage().equalsIgnoreCase("Unknown command. Type \"help\" for help.")) {
                    lr.setLevel(Level.ALL);
                    lr.setMessage(null);
                    suppressUnknownCommandMessage = false;
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
                throw new SecurityException("wtf are you doing?");
            }
        });
        pre1_3chatListener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void onPlayerChat(PlayerChatEvent e) {
                if (!SkriptConfig.enableEffectCommands || !e.getMessage().startsWith(SkriptConfig.effectCommandToken)) {
                    return;
                }
                if (Commands.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage())) {
                    e.setCancelled(true);
                }
            }
        };
        post1_3chatListener = new Listener(){

            @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
            public void onPlayerChat(final AsyncPlayerChatEvent e) {
                if (!SkriptConfig.enableEffectCommands || !e.getMessage().startsWith(SkriptConfig.effectCommandToken)) {
                    return;
                }
                if (!e.isAsynchronous()) {
                    if (Commands.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage())) {
                        e.setCancelled(true);
                    }
                } else {
                    Future f = Bukkit.getScheduler().callSyncMethod((Plugin)Skript.getInstance(), (Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return Commands.handleEffectCommand((CommandSender)e.getPlayer(), e.getMessage());
                        }
                    });
                    try {
                        while (true) {
                            try {
                                if (((Boolean)f.get()).booleanValue()) {
                                    e.setCancelled(true);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (ExecutionException e1) {
                        Skript.exception(e1, new String[0]);
                    }
                }
            }
        };
        registeredListener = false;
    }

    private static final String escape(String s) {
        return s.replaceAll("([" + escape + "])", "\\\\$1");
    }

    private static final String unescape(String s) {
        return s.replaceAll("\\\\([" + escape + "])", "$1");
    }

    private static final boolean handleCommand(CommandSender sender, String command) {
        ScriptCommand c;
        String[] cmd = command.split("\\s+", 2);
        cmd[0] = cmd[0].toLowerCase();
        if (cmd[0].endsWith("?") && (c = commands.get(cmd[0].substring(0, cmd[0].length() - 1))) != null) {
            c.sendHelp(sender);
            return true;
        }
        c = commands.get(cmd[0]);
        if (c != null) {
            if (cmd.length == 2 && cmd[1].equals("?")) {
                c.sendHelp(sender);
                return true;
            }
            if (SkriptConfig.logPlayerCommands && !(sender instanceof ConsoleCommandSender)) {
                Bukkit.getLogger().info(String.valueOf(sender.getName()) + ": /" + command);
            }
            c.execute(sender, cmd[0], cmd.length == 1 ? "" : cmd[1]);
            return true;
        }
        return false;
    }

    private static final boolean handleEffectCommand(CommandSender sender, String command) {
        if (!sender.hasPermission("skript.effectcommands")) {
            return false;
        }
        try {
            command = command.substring(SkriptConfig.effectCommandToken.length()).trim();
            SimpleLog log = SkriptLogger.startSubLog();
            ScriptLoader.currentEvents = Skript.array(CommandEvent.class);
            Effect e = Effect.parse(command, null);
            ScriptLoader.currentEvents = null;
            log.stop();
            if (e != null) {
                sender.sendMessage(ChatColor.GRAY + "executing '" + ChatColor.stripColor((String)command) + "'");
                if (SkriptConfig.logPlayerCommands && !(sender instanceof ConsoleCommandSender)) {
                    Skript.info(String.valueOf(sender.getName()) + " issued effect command: " + command);
                }
                e.run(new CommandEvent(sender, "effectcommand", new String[0]));
            } else {
                sender.sendMessage(ChatColor.RED + "Error in: " + ChatColor.GRAY + ChatColor.stripColor((String)command));
                log.printErrors(sender, "Can't understand this effect");
            }
            return true;
        }
        catch (Exception e) {
            Skript.exception(e, "Unexpected error while executing effect command '" + command + "' by '" + sender + "'");
            sender.sendMessage(ChatColor.RED + "An internal error occurred while executing this effect. See the server log for details.");
            return true;
        }
    }

    public static final ScriptCommand loadCommand(SectionNode node) {
        String s = node.getName();
        int level = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '[') {
                ++level;
            } else if (s.charAt(i) == ']') {
                if (level == 0) {
                    Skript.error("Invalid placement of [optional brackets]");
                    return null;
                }
                --level;
            }
            ++i;
        }
        if (level > 0) {
            Skript.error("Invalid amount of [optional brackets]");
            return null;
        }
        Matcher m = Pattern.compile("(?i)^command /?(\\S+)(\\s+(.+))?$").matcher(s);
        boolean a = m.matches();
        assert (a);
        String command = m.group(1);
        if (Commands.skriptCommandExists(command)) {
            Skript.error("A command with the name /" + command + " is already defined");
            return null;
        }
        String arguments = m.group(3) == null ? "" : m.group(3);
        StringBuilder pattern = new StringBuilder();
        currentArguments = new ArrayList();
        m = Pattern.compile("<([a-zA-Z -]+?)\\s*(=\\s*([^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?))?>").matcher(arguments);
        int lastEnd = 0;
        int optionals = 0;
        int i2 = 0;
        while (m.find()) {
            pattern.append(Commands.escape(arguments.substring(lastEnd, m.start())));
            optionals += StringUtils.count(arguments, '[', lastEnd, m.start());
            optionals -= StringUtils.count(arguments, ']', lastEnd, m.start());
            lastEnd = m.end();
            ClassInfo<?> c = Classes.getClassInfoFromUserInput(m.group(1));
            Pair<String, Boolean> p = Utils.getPlural(m.group(1));
            if (c == null) {
                c = Classes.getClassInfoFromUserInput((String)p.first);
            }
            if (c == null) {
                Skript.error("unknown type '" + m.group(1) + "'");
                return null;
            }
            if (c.getParser() == null || !c.getParser().canParse(ParseContext.COMMAND)) {
                Skript.error("can't use " + m.group(1) + " as argument of a command");
                return null;
            }
            Argument<?> arg = Argument.newInstance(c.getC(), m.group(3), i2, (Boolean)p.second == false, optionals > 0);
            if (arg == null) {
                return null;
            }
            currentArguments.add(arg);
            if (arg.isOptional() && optionals == 0) {
                pattern.append('[');
                ++optionals;
            }
            pattern.append("%" + (arg.isOptional() ? "-" : "") + Utils.toPlural(c.getCodeName(), (Boolean)p.second) + "%");
            ++i2;
        }
        pattern.append(Commands.escape(arguments.substring(lastEnd)));
        optionals += StringUtils.count(arguments, '[', lastEnd);
        optionals -= StringUtils.count(arguments, ']', lastEnd);
        i2 = 0;
        while (i2 < optionals) {
            pattern.append("]");
            ++i2;
        }
        node.convertToEntries(0);
        commandStructure.validate(node);
        if (!(node.get("trigger") instanceof SectionNode)) {
            return null;
        }
        String desc = "/" + command + " " + Commands.unescape(pattern.toString().replaceAll("%-?(.+?)%", "<$1>"));
        String usage = node.get("usage", desc);
        String description = node.get("description", "");
        List<String> aliases = Arrays.asList(node.get("aliases", "").split("\\s*,\\s*/?"));
        if (aliases.get(0).startsWith("/")) {
            aliases.set(0, aliases.get(0).substring(1));
        } else if (aliases.get(0).isEmpty()) {
            aliases = new ArrayList<String>(0);
        }
        String permission = node.get("permission", null);
        String permissionMessage = node.get("permission message", null);
        SectionNode trigger = (SectionNode)node.get("trigger");
        String[] by = node.get("executable by", "console,players").split("\\s*,\\s*|\\s+(and|or)\\s+");
        int executableBy = 0;
        String[] stringArray = by;
        int n = by.length;
        int n2 = 0;
        while (n2 < n) {
            String b = stringArray[n2];
            if (b.equalsIgnoreCase("console") || b.equalsIgnoreCase("the console")) {
                executableBy |= 2;
            } else if (b.equalsIgnoreCase("players") || b.equalsIgnoreCase("player")) {
                executableBy |= 1;
            } else {
                Skript.warning("'executable by' should be either be 'players', 'console' or both, but found '" + b + "'");
            }
            ++n2;
        }
        if (permissionMessage != null && permission == null) {
            Skript.warning("command /" + command + " has a permission message set, but not a permission");
        }
        if (Skript.debug()) {
            Skript.info("command " + desc + ":");
        }
        ScriptCommand c = new ScriptCommand(node.getConfig().getFile(), command, pattern.toString().replaceAll("[<>]", "\\\\$0"), currentArguments, description, usage, aliases, permission, permissionMessage, executableBy, ScriptLoader.loadItems(trigger));
        Commands.registerCommand(c);
        if (Skript.logVeryHigh() && !Skript.debug()) {
            Skript.info("registered command " + desc);
        }
        currentArguments = null;
        return c;
    }

    public static boolean skriptCommandExists(String command) {
        ScriptCommand c = commands.get(command);
        return c != null && c.getName().equals(command);
    }

    public static void registerCommand(ScriptCommand command) {
        if (commandMap != null) {
            command.register(commandMap, cmKnownCommands, cmAliases);
        }
        commands.put(command.getLabel(), command);
        for (String alias : command.getActiveAliases()) {
            commands.put(alias.toLowerCase(), command);
        }
        command.registerHelp();
    }

    public static int unregisterCommands(File script) {
        int numCommands = 0;
        Iterator<ScriptCommand> commandsIter = commands.values().iterator();
        while (commandsIter.hasNext()) {
            ScriptCommand c = commandsIter.next();
            if (!c.getScript().equals(script)) continue;
            ++numCommands;
            c.unregisterHelp();
            if (commandMap != null) {
                c.unregister(commandMap, cmKnownCommands, cmAliases);
            }
            commandsIter.remove();
        }
        return numCommands;
    }

    public static final void registerListener() {
        if (!registeredListener) {
            Bukkit.getPluginManager().registerEvents(commandListener, (Plugin)Skript.getInstance());
            if (Skript.isRunningBukkit(1, 3)) {
                Bukkit.getPluginManager().registerEvents(post1_3chatListener, (Plugin)Skript.getInstance());
            } else {
                Bukkit.getPluginManager().registerEvents(pre1_3chatListener, (Plugin)Skript.getInstance());
            }
            registeredListener = true;
        }
    }

    public static final void clearCommands() {
        if (commandMap != null) {
            for (ScriptCommand c : commands.values()) {
                c.unregister(commandMap, cmKnownCommands, cmAliases);
            }
        }
        for (ScriptCommand c : commands.values()) {
            c.unregisterHelp();
        }
        commands.clear();
    }

    public static final class CommandAliasHelpTopic
    extends HelpTopic {
        private final String aliasFor;
        private final HelpMap helpMap;

        public CommandAliasHelpTopic(String alias, String aliasFor, HelpMap helpMap) {
            this.aliasFor = aliasFor.startsWith("/") ? aliasFor : "/" + aliasFor;
            this.helpMap = helpMap;
            this.name = alias.startsWith("/") ? alias : "/" + alias;
            Validate.isTrue((!this.name.equals(this.aliasFor) ? 1 : 0) != 0, (String)("Command " + this.name + " cannot be alias for itself"));
            this.shortText = ChatColor.YELLOW + "Alias for " + ChatColor.WHITE + this.aliasFor;
        }

        public String getFullText(CommandSender forWho) {
            StringBuilder sb = new StringBuilder(this.shortText);
            HelpTopic aliasForTopic = this.helpMap.getHelpTopic(this.aliasFor);
            if (aliasForTopic != null) {
                sb.append("\n");
                sb.append(aliasForTopic.getFullText(forWho));
            }
            return sb.toString();
        }

        public boolean canSee(CommandSender commandSender) {
            if (this.amendedPermission == null) {
                HelpTopic aliasForTopic = this.helpMap.getHelpTopic(this.aliasFor);
                if (aliasForTopic != null) {
                    return aliasForTopic.canSee(commandSender);
                }
                return false;
            }
            return commandSender.hasPermission(this.amendedPermission);
        }
    }
}

