/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.classes.SerializableConverter;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Slot;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class DefaultConverters {
    static {
        Converters.registerConverter(OfflinePlayer.class, PlayerInventory.class, new SerializableConverter<OfflinePlayer, PlayerInventory>(){
            private static final long serialVersionUID = 1406259567778884904L;

            @Override
            public PlayerInventory convert(OfflinePlayer p) {
                if (!p.isOnline()) {
                    return null;
                }
                return p.getPlayer().getInventory();
            }
        });
        Converters.registerConverter(OfflinePlayer.class, Player.class, new SerializableConverter<OfflinePlayer, Player>(){
            private static final long serialVersionUID = 1784932642233241204L;

            @Override
            public Player convert(OfflinePlayer p) {
                return p.getPlayer();
            }
        });
        Converters.registerConverter(CommandSender.class, Player.class, new SerializableConverter<CommandSender, Player>(){
            private static final long serialVersionUID = -1461407582063991942L;

            @Override
            public Player convert(CommandSender s) {
                if (s instanceof Player) {
                    return (Player)s;
                }
                return null;
            }
        });
        Converters.registerConverter(Entity.class, Player.class, new SerializableConverter<Entity, Player>(){
            private static final long serialVersionUID = 6892053559153452238L;

            @Override
            public Player convert(Entity e) {
                if (e instanceof Player) {
                    return (Player)e;
                }
                return null;
            }
        });
        Converters.registerConverter(Block.class, Inventory.class, new SerializableConverter<Block, Inventory>(){
            private static final long serialVersionUID = -720656618540060571L;

            @Override
            public Inventory convert(Block b) {
                if (b.getState() instanceof InventoryHolder) {
                    return ((InventoryHolder)b.getState()).getInventory();
                }
                return null;
            }
        });
        Converters.registerConverter(Block.class, ItemStack.class, new SerializableConverter<Block, ItemStack>(){
            private static final long serialVersionUID = 1919746367202352251L;

            @Override
            public ItemStack convert(Block b) {
                return new ItemStack(b.getTypeId(), 1, (short)b.getData());
            }
        }, 1);
        Converters.registerConverter(Location.class, Block.class, new SerializableConverter<Location, Block>(){
            private static final long serialVersionUID = -5292388902665009733L;

            @Override
            public Block convert(Location l) {
                return l.getBlock();
            }
        });
        Converters.registerConverter(Block.class, Location.class, new SerializableConverter<Block, Location>(){
            private static final long serialVersionUID = -8082270387051361765L;

            @Override
            public Location convert(Block b) {
                return BlockUtils.getLocation(b);
            }
        });
        Converters.registerConverter(Entity.class, Location.class, new SerializableConverter<Entity, Location>(){
            private static final long serialVersionUID = 4290287600480149382L;

            @Override
            public Location convert(Entity e) {
                if (e == null) {
                    return null;
                }
                return e.getLocation();
            }
        });
        Converters.registerConverter(Entity.class, EntityData.class, new SerializableConverter<Entity, EntityData>(){
            private static final long serialVersionUID = -4840228378205738178L;

            @Override
            public EntityData convert(Entity e) {
                return EntityData.fromEntity(e);
            }
        });
        Converters.registerConverter(EntityData.class, EntityType.class, new SerializableConverter<EntityData, EntityType>(){
            private static final long serialVersionUID = -8509228303455103889L;

            @Override
            public EntityType convert(EntityData data) {
                return new EntityType(data, -1);
            }
        });
        Converters.registerConverter(ItemStack.class, ItemType.class, new SerializableConverter<ItemStack, ItemType>(){
            private static final long serialVersionUID = -5693219418938859295L;

            @Override
            public ItemType convert(ItemStack i) {
                if (i == null) {
                    return null;
                }
                return new ItemType(i);
            }
        });
        Converters.registerConverter(Slot.class, ItemStack.class, new SerializableConverter<Slot, ItemStack>(){
            private static final long serialVersionUID = -8985272066421244801L;

            @Override
            public ItemStack convert(Slot s) {
                if (s == null) {
                    return null;
                }
                ItemStack i = s.getItem();
                if (i == null) {
                    return new ItemStack(0, 1);
                }
                return i;
            }
        });
        Converters.registerConverter(Item.class, ItemStack.class, new SerializableConverter<Item, ItemStack>(){
            private static final long serialVersionUID = 7259092571473789525L;

            @Override
            public ItemStack convert(Item i) {
                if (i == null) {
                    return null;
                }
                return i.getItemStack();
            }
        });
        Converters.registerConverter(OfflinePlayer.class, InventoryHolder.class, new SerializableConverter<OfflinePlayer, InventoryHolder>(){
            private static final long serialVersionUID = 767824297432714799L;

            @Override
            public InventoryHolder convert(OfflinePlayer p) {
                if (p == null || !p.isOnline()) {
                    return null;
                }
                return p.getPlayer();
            }
        });
        Converters.registerConverter(Block.class, InventoryHolder.class, new SerializableConverter<Block, InventoryHolder>(){
            private static final long serialVersionUID = -9025690640371588378L;

            @Override
            public InventoryHolder convert(Block b) {
                if (b == null || b.getState() == null) {
                    return null;
                }
                BlockState s = b.getState();
                if (s instanceof InventoryHolder) {
                    return (InventoryHolder)s;
                }
                return null;
            }
        });
    }
}

