/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.SerializableChanger;
import ch.njol.skript.entity.XpOrbData;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;
import java.io.Serializable;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffectType;

public class DefaultChangers {
    public static final SerializableChanger<World, Object> timeChanger = new SerializableChanger<World, Object>(){
        private static final long serialVersionUID = -7723176266948346432L;

        @Override
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: 
                case REMOVE: {
                    return Skript.array(Timespan.class);
                }
                case SET: {
                    return Skript.array(Time.class);
                }
            }
            return null;
        }

        public void change(World[] worlds, Object delta, Changer.ChangeMode mode) {
            int mod = 1;
            switch (mode) {
                case SET: {
                    Time time = (Time)delta;
                    World[] worldArray = worlds;
                    int n = worlds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        World w = worldArray[n2];
                        w.setTime((long)time.getTicks());
                        ++n2;
                    }
                    break;
                }
                case REMOVE: {
                    mod = -1;
                }
                case ADD: {
                    Timespan ts = (Timespan)delta;
                    World[] worldArray = worlds;
                    int n = worlds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        World w = worldArray[n3];
                        w.setTime(w.getTime() + (long)(mod * ts.getTicks()));
                        ++n3;
                    }
                    break;
                }
            }
        }
    };
    public static final SerializableChanger<Entity, Object[]> entityChanger = new SerializableChanger<Entity, Object[]>(){
        private static final long serialVersionUID = 4191773847489489771L;

        @Override
        public Class<? extends Object[]>[] acceptChange(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: {
                    return Skript.array(ItemType[].class, XpOrbData[].class);
                }
                case CLEAR: {
                    return Skript.array(new Class[0]);
                }
                case REMOVE: {
                    return Skript.array(ItemType[].class, PotionEffectType[].class);
                }
                case SET: {
                    return null;
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public void change(Entity[] entities, Object[] delta, Changer.ChangeMode mode) {
            if (delta instanceof PotionEffectType[]) {
                Entity[] entityArray = entities;
                int n = entities.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity e = entityArray[n2];
                    if (e instanceof LivingEntity) {
                        PotionEffectType[] potionEffectTypeArray = (PotionEffectType[])delta;
                        int n3 = potionEffectTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PotionEffectType t = potionEffectTypeArray[n4];
                            ((LivingEntity)e).removePotionEffect(t);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            } else {
                Entity[] entityArray = entities;
                int n = entities.length;
                int n5 = 0;
                while (n5 < n) {
                    Entity e = entityArray[n5];
                    if (!(e instanceof Player)) {
                        if (mode == Changer.ChangeMode.CLEAR) {
                            e.remove();
                        }
                    } else if (mode != Changer.ChangeMode.CLEAR) {
                        int n6;
                        int n7;
                        Serializable[] serializableArray;
                        if (delta instanceof XpOrbData[]) {
                            int xp = 0;
                            serializableArray = (XpOrbData[])delta;
                            n7 = serializableArray.length;
                            n6 = 0;
                            while (n6 < n7) {
                                Serializable x = serializableArray[n6];
                                xp += ((XpOrbData)x).getExperience();
                                ++n6;
                            }
                            ((Player)e).giveExp(xp);
                        } else {
                            PlayerInventory invi = ((Player)e).getInventory();
                            serializableArray = (ItemType[])delta;
                            n7 = serializableArray.length;
                            n6 = 0;
                            while (n6 < n7) {
                                Serializable type = serializableArray[n6];
                                if (mode == Changer.ChangeMode.ADD) {
                                    ((ItemType)type).addTo((Inventory)invi);
                                } else {
                                    ((ItemType)type).removeFrom((Inventory)invi);
                                }
                                ++n6;
                            }
                            ((Player)e).updateInventory();
                        }
                    }
                    ++n5;
                }
            }
        }
    };
    public static final SerializableChanger<Entity, Object> nonLivingEntityChanger = new SerializableChanger<Entity, Object>(){
        private static final long serialVersionUID = 2080340413775243075L;

        @Override
        public Class<Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.CLEAR) {
                return Skript.array(new Class[0]);
            }
            return null;
        }

        public void change(Entity[] entities, Object delta, Changer.ChangeMode mode) {
            Entity[] entityArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Entity e = entityArray[n2];
                if (!(e instanceof Player)) {
                    e.remove();
                }
                ++n2;
            }
        }
    };
    public static final SerializableChanger<Player, Object> playerChanger = new SerializableChanger<Player, Object>(){
        private static final long serialVersionUID = 9048165091425550382L;

        @Override
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.CLEAR) {
                return null;
            }
            return Skript.array(ItemType[].class, Inventory.class);
        }

        public void change(Player[] players, Object delta, Changer.ChangeMode mode) {
            Player[] playerArray = players;
            int n = players.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                PlayerInventory invi = p.getInventory();
                if (delta instanceof Inventory) {
                    if (mode == Changer.ChangeMode.ADD) {
                        invi.addItem(((Inventory)delta).getContents());
                    } else {
                        invi.removeItem(((Inventory)delta).getContents());
                    }
                } else {
                    ItemType[] itemTypeArray = (ItemType[])delta;
                    int n3 = itemTypeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ItemType type = itemTypeArray[n4];
                        if (mode == Changer.ChangeMode.ADD) {
                            type.addTo((Inventory)invi);
                        } else {
                            type.removeFrom((Inventory)invi);
                        }
                        ++n4;
                    }
                }
                p.updateInventory();
                ++n2;
            }
        }
    };
    public static final SerializableChanger<Inventory, Object> inventoryChanger = new SerializableChanger<Inventory, Object>(){
        private static final long serialVersionUID = -8150546084341399001L;

        @Override
        public Class<? extends Object>[] acceptChange(Changer.ChangeMode mode) {
            return Skript.array(ItemType[].class, Inventory.class);
        }

        public void change(Inventory[] invis, Object delta, Changer.ChangeMode mode) {
            Inventory[] inventoryArray = invis;
            int n = invis.length;
            int n2 = 0;
            while (n2 < n) {
                Inventory invi = inventoryArray[n2];
                switch (mode) {
                    case SET: 
                    case CLEAR: {
                        invi.clear();
                        if (invi instanceof PlayerInventory) {
                            ((PlayerInventory)invi).setArmorContents(new ItemStack[4]);
                        }
                        if (mode == Changer.ChangeMode.CLEAR) break;
                    }
                    case ADD: {
                        ItemType type;
                        if (delta instanceof Inventory) {
                            invi.addItem(((Inventory)delta).getContents());
                            break;
                        }
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n3 = itemTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.addTo(invi);
                            ++n4;
                        }
                        break;
                    }
                    case REMOVE: {
                        ItemType type;
                        if (delta instanceof Inventory) {
                            invi.removeItem(((Inventory)delta).getContents());
                            break;
                        }
                        ItemType[] itemTypeArray = (ItemType[])delta;
                        int n3 = itemTypeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            type = itemTypeArray[n4];
                            type.removeFrom(invi);
                            ++n4;
                        }
                        break;
                    }
                }
                if (invi instanceof PlayerInventory) {
                    ((Player)invi.getHolder()).updateInventory();
                }
                ++n2;
            }
        }
    };
    public static final SerializableChanger<Block, Object> blockChanger = new SerializableChanger<Block, Object>(){
        private static final long serialVersionUID = -490468386085652881L;

        @Override
        public Class<?>[] acceptChange(Changer.ChangeMode mode) {
            if (mode == Changer.ChangeMode.SET) {
                return Skript.array(ItemType.class);
            }
            return Skript.array(ItemType[].class, Inventory.class);
        }

        public void change(Block[] blocks, Object delta, Changer.ChangeMode mode) {
            Block[] blockArray = blocks;
            int n = blocks.length;
            int n2 = 0;
            while (n2 < n) {
                Block block = blockArray[n2];
                switch (mode) {
                    case SET: {
                        ((ItemType)delta).setBlock(block, true);
                        break;
                    }
                    case CLEAR: {
                        block.setTypeId(0, true);
                        break;
                    }
                    case ADD: 
                    case REMOVE: {
                        ItemType type;
                        int n3;
                        int n4;
                        ItemType[] itemTypeArray;
                        BlockState state = block.getState();
                        if (!(state instanceof InventoryHolder)) break;
                        Inventory invi = ((InventoryHolder)state).getInventory();
                        if (mode == Changer.ChangeMode.ADD) {
                            if (delta instanceof Inventory) {
                                invi.addItem(((Inventory)delta).getContents());
                            } else {
                                itemTypeArray = (ItemType[])delta;
                                n4 = itemTypeArray.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    type = itemTypeArray[n3];
                                    type.addTo(invi);
                                    ++n3;
                                }
                            }
                        } else if (delta instanceof Inventory) {
                            invi.removeItem(((Inventory)delta).getContents());
                        } else {
                            itemTypeArray = (ItemType[])delta;
                            n4 = itemTypeArray.length;
                            n3 = 0;
                            while (n3 < n4) {
                                type = itemTypeArray[n3];
                                type.removeFrom(invi);
                                ++n3;
                            }
                        }
                        state.update();
                    }
                }
                ++n2;
            }
        }
    };
}

