/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class Variables {
    private boolean loadError = false;
    private final TreeMap<String, Object> variables = new TreeMap(variableNameComparator);
    private static final Comparator<String> variableNameComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null) {
                return s2 == null ? 0 : -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    };
    private final Map<String, WeakHashMap<Event, Object>> localVariables = new HashMap<String, WeakHashMap<Event, Object>>();
    private File file;
    private volatile PrintWriter changesWriter;
    private final LinkedBlockingQueue<String[]> changesQueue = new LinkedBlockingQueue();
    private final Thread changesWriterThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Variables.writeCSV(Variables.this.changesWriter, (String[])Variables.this.changesQueue.take());
                        Variables.this.changesWriter.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    });
    private volatile int changes = 0;
    private static final int REQUIRED_CHANGES_FOR_RESAVE = 50;
    private Task saveTask;
    private Task backupTask = null;
    private static final Pattern csv = Pattern.compile("\\s*([^\",]+|\"([^\"]|\"\")*\")\\s*(,|$)");

    public void startBackupTask(Timespan t) {
        this.backupTask = new Task(Skript.getInstance(), t.getTicks(), t.getTicks(), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TreeMap treeMap = Variables.this.variables;
                synchronized (treeMap) {
                    block8: {
                        Variables.this.closeChangesWriter();
                        try {
                            try {
                                FileUtils.backup(Variables.this.file);
                            }
                            catch (IOException e) {
                                Skript.error("Automatic variables backup failed: " + e.getLocalizedMessage());
                                Variables.this.setupChangesWriter();
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            Variables.this.setupChangesWriter();
                            throw throwable;
                        }
                        Variables.this.setupChangesWriter();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVariable(String[] name, Object value) {
        TreeMap<String, Object> treeMap = this.variables;
        synchronized (treeMap) {
            TreeMap<String, Object> current = this.variables;
            int i = 0;
            while (i < name.length) {
                String n = name[i];
                TreeMap o = current.get(n);
                if (o == null) {
                    if (i == name.length - 1) {
                        current.put(n, value);
                        break;
                    }
                    if (value != null) {
                        o = new TreeMap(variableNameComparator);
                        current.put(n, o);
                        current = o;
                    }
                } else if (o instanceof TreeMap) {
                    if (i == name.length - 1) {
                        ((TreeMap)o).put(null, value);
                        break;
                    }
                    if (i == name.length - 2 && name[i + 1].equals("*")) {
                        assert (value == null);
                        Object v = o.get(null);
                        current.put(n, v);
                        break;
                    }
                    current = o;
                } else {
                    if (i == name.length - 1) {
                        current.put(n, value);
                        break;
                    }
                    if (value != null) {
                        TreeMap c = new TreeMap(variableNameComparator);
                        c.put(null, o);
                        current.put(n, c);
                        current = c;
                    }
                }
                ++i;
            }
            this.saveVariableChange(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object getVariable(String[] name) {
        TreeMap<String, Object> treeMap = this.variables;
        synchronized (treeMap) {
            TreeMap current = this.variables;
            int i = 0;
            while (true) {
                if (i >= name.length) {
                    return null;
                }
                String n = name[i];
                if (n.equals("*")) {
                    return Collections.unmodifiableSortedMap(current);
                }
                Object o = current.get(n);
                if (o == null) {
                    return null;
                }
                if (o instanceof Map) {
                    current = (TreeMap)o;
                    if (i == name.length - 1) {
                        return current.get(null);
                    }
                } else {
                    if (i != name.length - 1) return null;
                    Object object = o;
                    return object;
                }
                ++i;
            }
        }
    }

    public final void setLocalVariable(String name, Event e, Object value) {
        WeakHashMap<Object, Object> map = this.localVariables.get(name);
        if (map == null) {
            map = new WeakHashMap();
            this.localVariables.put(name, map);
        }
        map.put(e, value);
    }

    public final Object getLocalVariable(String name, Event e) {
        WeakHashMap<Event, Object> map = this.localVariables.get(name);
        if (map == null) {
            return null;
        }
        return map.get(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean loadVariables() {
        assert (!Thread.holdsLock(this.variables));
        TreeMap<String, Object> treeMap = this.variables;
        synchronized (treeMap) {
            boolean ioEx;
            StringBuilder invalid;
            int unsuccessful;
            SimpleLog log;
            block44: {
                block42: {
                    assert (this.variables.isEmpty());
                    this.file = new File(Skript.getInstance().getDataFolder(), "variables.csv");
                    try {
                        this.file.createNewFile();
                    }
                    catch (IOException e) {
                        Skript.error("Cannot create the variables file: " + e.getLocalizedMessage());
                        return false;
                    }
                    if (!this.file.canWrite()) {
                        Skript.error("Cannot write to the variables file - no variables will be saved!");
                    }
                    if (this.file.canRead()) break block42;
                    Skript.error("Cannot read from the variables file!");
                    Skript.error("This means that no variables will be available and can also prevent new variables from being saved!");
                    try {
                        File backup = FileUtils.backup(this.file);
                        Skript.info("Created a backup of your variables.csv as " + backup.getName());
                    }
                    catch (IOException e) {
                        Skript.error("Failed to create a backup of your variables.csv: " + e.getLocalizedMessage());
                        this.loadError = true;
                    }
                    return false;
                }
                log = SkriptLogger.startSubLog();
                unsuccessful = 0;
                invalid = new StringBuilder();
                Version varVersion = Skript.getVersion();
                Version v2_0_beta3 = new Version(2, 0, "beta 3");
                BufferedReader r = null;
                ioEx = false;
                try {
                    try {
                        r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
                        String line = null;
                        int lineNum = 0;
                        while ((line = r.readLine()) != null) {
                            ++lineNum;
                            if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                                if (!line.startsWith("# version:")) continue;
                                try {
                                    varVersion = new Version(line.substring("# version:".length()).trim());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {}
                                continue;
                            }
                            String[] split = Variables.splitCSV(line);
                            if (split == null || split.length != 3) {
                                Skript.error("invalid amount of commas in line " + lineNum + " ('" + line + "')");
                                if (invalid.length() != 0) {
                                    invalid.append(", ");
                                }
                                invalid.append(split == null ? "<unknown>" : split[0]);
                                ++unsuccessful;
                                continue;
                            }
                            if (split[1].equals("null")) {
                                this.setVariable(Variable.splitVariableName(split[0]), null);
                                continue;
                            }
                            Object d = Classes.deserialize(split[1], split[2]);
                            if (d == null) {
                                if (invalid.length() != 0) {
                                    invalid.append(", ");
                                }
                                invalid.append(split[0]);
                                ++unsuccessful;
                                continue;
                            }
                            if (d instanceof String && varVersion.isSmallerThan(v2_0_beta3)) {
                                d = Utils.replaceChatStyles((String)d);
                            }
                            this.setVariable(Variable.splitVariableName(split[0]), d);
                        }
                    }
                    catch (IOException e) {
                        Skript.error(e.getLocalizedMessage());
                        this.loadError = true;
                        ioEx = true;
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            log.stop();
            if (ioEx || unsuccessful > 0) {
                if (unsuccessful > 0) {
                    Skript.error(String.valueOf(unsuccessful) + " variable" + (unsuccessful == 1 ? "" : "s") + " could not be loaded!");
                    Skript.error("Affected variables: " + invalid.toString());
                    if (log.hasErrors()) {
                        Skript.error("further information:");
                        log.printErrors(null);
                    }
                }
                if (ioEx) {
                    Skript.error("An I/O error occurred while loading the variables");
                    Skript.error("This means that some to all variables could not be loaded!");
                }
                try {
                    File backup = FileUtils.backup(this.file);
                    Skript.info("Created a backup of variables.csv as " + backup.getName());
                    this.loadError = false;
                }
                catch (IOException ex) {
                    Skript.error("Could not backup variables.csv: " + ex.getMessage());
                }
            }
            this.setupChangesWriter();
            this.changesWriterThread.start();
            this.saveTask = new Task(Skript.getInstance(), 6000L, 6000L, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TreeMap treeMap = Variables.this.variables;
                    synchronized (treeMap) {
                        if (Variables.this.changes >= 50) {
                            Variables.this.saveVariables(false);
                            Variables.this.changes = 0;
                        }
                    }
                }
            };
            if (this.backupTask == null && SkriptConfig.variableBackupPeriod != null) {
                this.startBackupTask(SkriptConfig.variableBackupPeriod);
            }
            return !ioEx;
        }
    }

    private static final String[] splitCSV(String line) {
        Matcher m = csv.matcher(line);
        int lastEnd = 0;
        ArrayList<String> r = new ArrayList<String>();
        while (m.find()) {
            if (lastEnd != m.start()) {
                return null;
            }
            if (m.group(1).startsWith("\"")) {
                r.add(m.group(1).substring(1, m.group(1).length() - 1).replace("\"\"", "\""));
            } else {
                r.add(m.group(1));
            }
            lastEnd = m.end();
        }
        if (lastEnd != line.length()) {
            return null;
        }
        return r.toArray(new String[r.size()]);
    }

    private static final void writeCSV(PrintWriter pw, String ... values) {
        int i = 0;
        while (i < values.length) {
            String v;
            if (i != 0) {
                pw.print(", ");
            }
            if ((v = values[i]).contains(",") || v.contains("\"")) {
                v = String.valueOf('\"') + v.replace("\"", "\"\"") + '\"';
            }
            pw.print(v);
            ++i;
        }
        pw.println();
    }

    private final void saveVariableChange(String[] name, Object value) {
        assert (Thread.holdsLock(this.variables));
        if (this.changesWriter != null) {
            String[] s;
            ++this.changes;
            String[] stringArray = s = value == null ? null : Classes.serialize(value);
            if (s == null) {
                this.changesQueue.add(new String[]{StringUtils.join(name, "::"), "null", "null"});
            } else {
                this.changesQueue.add(new String[]{StringUtils.join(name, "::"), s[0], s[1]});
            }
        }
    }

    final void closeChangesWriter() {
        assert (Thread.holdsLock(this.variables));
        this.changesQueue.clear();
        this.changesWriter.close();
        this.changesWriter = null;
    }

    final void setupChangesWriter() {
        assert (Thread.holdsLock(this.variables));
        try {
            this.changesWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveVariables(boolean finalSave) {
        if (finalSave) {
            this.saveTask.cancel();
            if (this.backupTask != null) {
                this.backupTask.cancel();
            }
        }
        TreeMap<String, Object> treeMap = this.variables;
        synchronized (treeMap) {
            block22: {
                this.closeChangesWriter();
                try {
                    if (this.loadError) {
                        try {
                            File backup = FileUtils.backup(this.file);
                            Skript.info("Created a backup of your old variables.csv as " + backup.getName());
                            this.loadError = false;
                        }
                        catch (IOException e) {
                            Skript.error("Could not backup the old variables.csv: " + e.getLocalizedMessage());
                            Skript.error("No variables are saved!");
                            if (!finalSave) {
                                this.setupChangesWriter();
                            }
                            return;
                        }
                    }
                    File tempFile = new File(Skript.getInstance().getDataFolder(), "variables.csv.temp");
                    PrintWriter pw = null;
                    try {
                        try {
                            pw = new PrintWriter(tempFile, "UTF-8");
                            pw.println("# Skript's variable storage");
                            pw.println("# Please do not modify this file manually!");
                            pw.println("#");
                            pw.println("# version: " + Skript.getInstance().getDescription().getVersion());
                            pw.println();
                            Variables.save(pw, "", this.variables);
                            pw.println();
                            pw.flush();
                            pw.close();
                            FileUtils.move(tempFile, this.file, true);
                        }
                        catch (IOException e) {
                            Skript.error("Unable to save variables: " + e.getLocalizedMessage());
                            if (pw != null) {
                                pw.close();
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pw != null) {
                            pw.close();
                        }
                        throw throwable;
                    }
                    if (pw != null) {
                        pw.close();
                    }
                }
                finally {
                    if (!finalSave) {
                        this.setupChangesWriter();
                    }
                }
            }
        }
    }

    private static final void save(PrintWriter pw, String parent, TreeMap<String, Object> map) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (e.getValue() == null) continue;
            if (e.getValue() instanceof TreeMap) {
                Variables.save(pw, String.valueOf(parent) + e.getKey() + "::", (TreeMap)e.getValue());
                continue;
            }
            String[] s = Classes.serialize(e.getValue());
            if (s == null) continue;
            Variables.writeCSV(pw, e.getKey() == null ? parent.substring(0, parent.length() - 2) : String.valueOf(parent) + e.getKey(), s[0], s[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numVariables() {
        TreeMap<String, Object> treeMap = this.variables;
        synchronized (treeMap) {
            return this.numVariables(this.variables);
        }
    }

    private int numVariables(TreeMap<String, Object> m) {
        int r = 0;
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (e instanceof TreeMap) {
                r += this.numVariables((TreeMap)((Object)e));
                continue;
            }
            ++r;
        }
        return r;
    }
}

