/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.FormattedMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Version;
import ch.njol.util.ExceptionUtils;
import ch.njol.util.SynchronizedReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.StringEscapeUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public final class Updater {
    private static final String rssURL = "http://dev.bukkit.org/server-mods/skript/files.rss";
    private static final DateFormat RFC2822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    public static final Object stateLock = new Object();
    public static volatile UpdateState state = UpdateState.NOT_STARTED;
    private static final SynchronizedReference<String> error = new SynchronizedReference();
    public static final List<VersionInfo> infos = new ArrayList<VersionInfo>();
    public static final SynchronizedReference<VersionInfo> latest = new SynchronizedReference();
    public static final Message m_not_started = new Message("updater.not_started");
    public static final Message m_checking = new Message("updater.checking");
    public static final Message m_check_in_progress = new Message("updater.check_in_progress");
    public static final FormattedMessage m_check_error = new FormattedMessage("updater.check_error", error);
    public static final Message m_running_latest_version = new Message("updater.running_latest_version");
    public static final FormattedMessage m_update_available = new FormattedMessage("updater.update_available", latest, Skript.getVersion());
    public static final FormattedMessage m_downloading = new FormattedMessage("updater.downloading", latest);
    public static final Message m_download_in_progress = new Message("updater.download_in_progress");
    public static final FormattedMessage m_download_error = new FormattedMessage("updater.download_error", error);
    public static final Message m_downloaded = new Message("updater.downloaded");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void check(final CommandSender sender, final boolean download, final boolean isAutomatic) {
        assert (sender != null);
        Object object = stateLock;
        synchronized (object) {
            if (state != UpdateState.NOT_STARTED && state != UpdateState.CHECK_ERROR) {
                throw new IllegalStateException("Cannot check for an update twice");
            }
            state = UpdateState.CHECK_IN_PROGRESS;
        }
        Skript.info(sender, Language.get("updater.checking"));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block53: {
                    InputStream in = null;
                    InputStreamReader r = null;
                    try {
                        try {
                            Object object;
                            String message;
                            URLConnection conn = new URL(Updater.rssURL).openConnection();
                            in = conn.getInputStream();
                            r = new InputStreamReader(in, conn.getContentEncoding() == null ? "UTF-8" : conn.getContentEncoding());
                            XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(r);
                            infos.clear();
                            VersionInfo current = null;
                            while (reader.hasNext()) {
                                XMLEvent e = reader.nextEvent();
                                if (e.isStartElement()) {
                                    String element = e.asStartElement().getName().getLocalPart();
                                    if (current == null) {
                                        if (!element.equalsIgnoreCase("item")) continue;
                                        current = new VersionInfo();
                                        continue;
                                    }
                                    if (element.equalsIgnoreCase("title")) {
                                        String version = reader.nextEvent().asCharacters().getData();
                                        if (!version.matches("\\d+\\.\\d+(\\.\\d+)? \\(zip\\)")) {
                                            current = null;
                                            continue;
                                        }
                                        current.version = new Version(version.substring(0, version.length() - " (zip)".length()));
                                        if (current.version.compareTo(Skript.getVersion()) > 0) continue;
                                        break;
                                    }
                                    if (element.equalsIgnoreCase("link")) {
                                        current.pageURL = reader.nextEvent().asCharacters().getData();
                                        continue;
                                    }
                                    if (element.equalsIgnoreCase("description")) {
                                        String cl = "";
                                        while ((e = reader.nextEvent()).isCharacters()) {
                                            cl = String.valueOf(cl) + e.asCharacters().getData();
                                        }
                                        current.changelog = "- " + StringEscapeUtils.unescapeHtml((String)cl).replace("<br>", "").replace("<p>", "").replace("</p>", "").replaceAll("\n(?!\n)", "\n- ");
                                        continue;
                                    }
                                    if (!element.equalsIgnoreCase("pubDate")) continue;
                                    current.date = new Date(RFC2822.parse(reader.nextEvent().asCharacters().getData()).getTime());
                                    continue;
                                }
                                if (!e.isEndElement() || !e.asEndElement().getName().getLocalPart().equalsIgnoreCase("item")) continue;
                                if (current != null) {
                                    infos.add(current);
                                }
                                current = null;
                            }
                            if (!infos.isEmpty()) {
                                Collections.sort(infos, new Comparator<VersionInfo>(){

                                    @Override
                                    public int compare(VersionInfo v1, VersionInfo v2) {
                                        return v2.version.compareTo(v1.version);
                                    }
                                });
                                latest.set(infos.get(0));
                            }
                            String string = message = infos.isEmpty() ? "" + m_running_latest_version : "" + m_update_available;
                            if (isAutomatic && !infos.isEmpty()) {
                                Skript.adminBroadcast(message);
                            } else {
                                Skript.info(sender, message);
                            }
                            if (download && !infos.isEmpty()) {
                                object = stateLock;
                                synchronized (object) {
                                    state = UpdateState.DOWNLOAD_IN_PROGRESS;
                                }
                                Updater.download_i(sender, isAutomatic);
                                break block53;
                            }
                            object = stateLock;
                            synchronized (object) {
                                state = UpdateState.CHECKED_FOR_UPDATE;
                            }
                        }
                        catch (IOException e) {
                            Skript.error(sender, Language.format("updater.check_error", ExceptionUtils.toString(e)));
                            Object object = stateLock;
                            synchronized (object) {
                                state = UpdateState.CHECK_ERROR;
                                error.set(ExceptionUtils.toString(e));
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (Exception e) {
                            block54: {
                                Skript.error(sender, "An internal error occurred while checking for the latest version of Skript. See the erver log for details.");
                                Skript.exception(e, "Error while checking for a new version of Skript");
                                Object object = stateLock;
                                synchronized (object) {
                                    state = UpdateState.CHECK_ERROR;
                                    error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                                }
                                if (in == null) break block54;
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }).start();
    }

    private static final String getFileURL(String pageURL) throws MalformedURLException, IOException {
        InputStream in = null;
        try {
            URLConnection conn = new URL(pageURL).openConnection();
            in = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, conn.getContentEncoding() == null ? "UTF-8" : conn.getContentEncoding()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int e;
                    int s = line.indexOf("<a href=\"http://dev.bukkit.org/media/files/");
                    if (s == -1 || (e = line.indexOf("\">", s + "<a href=\"http://dev.bukkit.org/media/files/".length())) == -1) continue;
                    String string = line.substring(s + "<a href=\"".length(), e);
                    return string;
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new IOException("Could not get the file's URL. You can however download Skript manually from " + pageURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void download_i(CommandSender sender, boolean isAutomatic) {
        Object object = stateLock;
        synchronized (object) {
            if (state != UpdateState.DOWNLOAD_IN_PROGRESS) {
                throw new IllegalStateException();
            }
        }
        Skript.info(sender, "" + m_downloading);
        boolean hasJar = false;
        boolean hasConfig = true;
        ZipInputStream zip = null;
        try {
            try {
                ZipEntry entry;
                URLConnection conn = new URL(Updater.getFileURL(Updater.latest.get().pageURL)).openConnection();
                zip = new ZipInputStream(conn.getInputStream());
                while ((entry = zip.getNextEntry()) != null) {
                    if (entry.getName().endsWith("Skript.jar")) {
                        Bukkit.getUpdateFolderFile().mkdirs();
                        File update = new File(Bukkit.getUpdateFolderFile(), "Skript.jar");
                        FileOutputStream out = null;
                        try {
                            int read;
                            out = new FileOutputStream(update);
                            byte[] buffer = new byte[4096];
                            while ((read = zip.read(buffer)) > 0) {
                                out.write(buffer, 0, read);
                            }
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                        hasJar = true;
                    }
                    if (hasJar) break;
                    zip.closeEntry();
                }
                if (isAutomatic) {
                    Skript.adminBroadcast(Language.get("updater.downloaded"));
                } else {
                    Skript.info(sender, Language.get("updater.downloaded"));
                }
                Object object2 = stateLock;
                synchronized (object2) {
                    state = UpdateState.DOWNLOADED;
                    return;
                }
            }
            catch (IOException e) {
                Skript.error(sender, Language.format("updater.download_error", ExceptionUtils.toString(e)));
                Object object3 = stateLock;
                synchronized (object3) {
                    state = UpdateState.DOWNLOAD_ERROR;
                    error.set(ExceptionUtils.toString(e));
                }
                if (zip == null) return;
                try {
                    zip.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
            catch (Exception e) {
                Skript.exception(e, "Error while downloading the latest version of Skript");
                Object object4 = stateLock;
                synchronized (object4) {
                    state = UpdateState.DOWNLOAD_ERROR;
                    error.set(String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                }
                if (zip == null) return;
                try {
                    zip.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(final CommandSender sender, final boolean isAutomatic) {
        assert (sender != null);
        Object object = stateLock;
        synchronized (object) {
            if (state != UpdateState.CHECKED_FOR_UPDATE && state != UpdateState.DOWNLOAD_ERROR) {
                throw new IllegalStateException("Must check for an update first");
            }
            state = UpdateState.DOWNLOAD_IN_PROGRESS;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                Updater.download_i(sender, isAutomatic);
            }
        }).start();
    }

    public static enum UpdateState {
        NOT_STARTED,
        CHECK_IN_PROGRESS,
        CHECK_ERROR,
        CHECKED_FOR_UPDATE,
        DOWNLOAD_IN_PROGRESS,
        DOWNLOAD_ERROR,
        DOWNLOADED;

    }

    public static final class VersionInfo {
        Version version;
        String pageURL;
        String changelog;
        Date date;
    }
}

