/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.Updater;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.CommandHelp;
import ch.njol.skript.util.FileUtils;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.util.ChatPaginator;

public class SkriptCommand
implements CommandExecutor {
    private static final CommandHelp skriptCommandHelp = new CommandHelp("<gray>/<gold>skript", "Skript's main command", "cyan").add(new CommandHelp("reload", "Reloads the config, all scripts, everything, or a specific script", "red").add("all", "Reloads all configs and all scripts").add("config", "Reloads the main config").add("aliases", "Reloads the aliases config").add("scripts", "Reloads all scripts").add("<script>", "Reloads a specific script")).add(new CommandHelp("enable", "Enables all scripts or a specific one", "red").add("all", "Enables all scripts").add("<script>", "Enables a specific script")).add(new CommandHelp("disable", "Disables all scripts or a specific one", "red").add("all", "Disables all scripts").add("<script>", "Disables a specific script")).add(new CommandHelp("update", "Check for updates, read the changelog, and download the latest version of Skript", "red").add("check", "Checks for a new version").add("changes", "See what changed in the newest version").add("download", "Download the newest version")).add("help", "Prints this help message");
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        block60: {
            block70: {
                block68: {
                    block69: {
                        block66: {
                            block67: {
                                block62: {
                                    block65: {
                                        block64: {
                                            block63: {
                                                if (!SkriptCommand.skriptCommandHelp.test(sender, args)) {
                                                    return true;
                                                }
                                                if (!args[0].equalsIgnoreCase("reload")) break block62;
                                                if (args[1].equalsIgnoreCase("all")) {
                                                    log = SkriptLogger.startSubLog();
                                                    Skript.reload();
                                                    log.stop();
                                                    if (log.hasErrors()) {
                                                        Skript.error(sender, "Error(s) while reloading the config and all scripts:");
                                                        log.printErrors(sender, null);
                                                    } else {
                                                        Skript.info(sender, "Successfully reloaded the config and all scripts");
                                                    }
                                                    return true;
                                                }
                                                if (!args[1].equalsIgnoreCase("scripts")) break block63;
                                                log = SkriptLogger.startSubLog();
                                                Skript.reloadScripts();
                                                log.stop();
                                                if (log.hasErrors()) {
                                                    Skript.error(sender, "Error(s) while reloading all scripts:");
                                                    log.printErrors(sender, null);
                                                } else {
                                                    Skript.info(sender, "Successfully reloaded all scripts");
                                                }
                                                break block60;
                                            }
                                            if (!args[1].equalsIgnoreCase("config")) break block64;
                                            log = SkriptLogger.startSubLog();
                                            Skript.reloadMainConfig();
                                            log.stop();
                                            if (log.hasErrors()) {
                                                Skript.error(sender, "Error(s) while reloading the main config:");
                                                log.printErrors(sender, null);
                                            } else {
                                                Skript.info(sender, "Successfully reloaded the main config");
                                            }
                                            break block60;
                                        }
                                        if (!args[1].equalsIgnoreCase("aliases")) break block65;
                                        log = SkriptLogger.startSubLog();
                                        Skript.reloadAliases();
                                        log.stop();
                                        if (log.hasErrors()) {
                                            Skript.error(sender, "Error(s) while reloading the aliases config:");
                                            log.printErrors(sender, null);
                                        } else {
                                            Skript.info(sender, "Successfully reloaded the aliases config");
                                        }
                                        break block60;
                                    }
                                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                                    if (f == null) {
                                        return true;
                                    }
                                    if (f.getName().startsWith("-")) {
                                        Skript.info(sender, "This script is currently disabled. Use <gray>/<gold>skript <cyan>enable <red>" + StringUtils.join(args, " ", 1, args.length) + "<reset> to enable it.");
                                        return true;
                                    }
                                    ScriptLoader.unloadScript(f);
                                    log = SkriptLogger.startSubLog();
                                    ScriptLoader.loadScripts(Arrays.asList(new File[]{f}));
                                    log.stop();
                                    if (log.hasErrors()) {
                                        Skript.error(sender, "Error(s) while reloading <gold>" + f.getName() + "<red>:");
                                        log.printErrors(sender, null);
                                    } else {
                                        Skript.info(sender, "Successfully reloaded <gold>" + f.getName() + "<reset>!");
                                    }
                                    return true;
                                }
                                if (!args[0].equalsIgnoreCase("enable")) break block66;
                                if (!args[1].equals("all")) break block67;
                                try {
                                    files = SkriptCommand.toggleScripts(true);
                                    log = SkriptLogger.startSubLog();
                                    ScriptLoader.loadScripts(files);
                                    log.stop();
                                    if (log.hasErrors()) {
                                        Skript.error(sender, "Error(s) while loading disabled scripts:");
                                        log.printErrors(sender, null);
                                        break block60;
                                    }
                                    Skript.info(sender, "Successfully loaded & enabled all previously disabled scripts!");
                                }
                                catch (IOException e) {
                                    Skript.error(sender, "Could not enable any scripts (some scripts might have been renamed already and will be enabled when the server restarts): " + e.getLocalizedMessage());
                                }
                                break block60;
                            }
                            f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                            if (f == null) {
                                return true;
                            }
                            if (!f.getName().startsWith("-")) {
                                Skript.info(sender, "<gold>" + f.getName() + "<reset> is already enabled! Use <gray>/<gold>skript <cyan>reload <red>" + StringUtils.join(args, " ", 1, args.length) + "<reset> to reload it if it was changed.");
                                return true;
                            }
                            try {
                                FileUtils.move(f, new File(f.getParentFile(), f.getName().substring(1)), false);
                            }
                            catch (IOException e) {
                                Skript.error(sender, "Could not enable <gold>" + f.getName().substring(1) + "<red>:<reset> " + e.getLocalizedMessage());
                                return true;
                            }
                            f = new File(f.getParentFile(), f.getName().substring(1));
                            log = SkriptLogger.startSubLog();
                            ScriptLoader.loadScripts(Arrays.asList(new File[]{f}));
                            log.stop();
                            if (log.hasErrors()) {
                                Skript.error(sender, "Error(s) while enabling <gold>" + f.getName() + "<red>:");
                                log.printErrors(sender, null);
                            } else {
                                Skript.info(sender, "Successfully enabled <gold>" + f.getName() + "<reset>!");
                            }
                            return true;
                        }
                        if (!args[0].equalsIgnoreCase("disable")) break block68;
                        if (!args[1].equals("all")) break block69;
                        Skript.disableScripts();
                        try {
                            SkriptCommand.toggleScripts(false);
                            Skript.info(sender, "Successfully disabled all scripts!");
                        }
                        catch (IOException e) {
                            Skript.error(sender, "Could not rename all scripts - some scripts will be enabled again when you restart the server:<reset> " + e.getLocalizedMessage());
                        }
                        break block60;
                    }
                    f = SkriptCommand.getScriptFromArgs(sender, args, 1);
                    if (f == null) {
                        return true;
                    }
                    if (f.getName().startsWith("-")) {
                        Skript.info(sender, "<gold>" + f.getName().substring(1) + "<reset> is already disabled!");
                        return true;
                    }
                    ScriptLoader.unloadScript(f);
                    try {
                        FileUtils.move(f, new File(f.getParentFile(), "-" + f.getName()), false);
                    }
                    catch (IOException e) {
                        Skript.error(sender, "Could not rename <gold>" + f.getName() + "<red>, it will be enabled again when you restart the server:<reset> " + e.getLocalizedMessage());
                        return true;
                    }
                    Skript.info(sender, "Successfully disabled <gold>" + f.getName() + "<reset>!");
                    return true;
                }
                if (!args[0].equalsIgnoreCase("update")) break block70;
                var5_15 = Updater.stateLock;
                synchronized (var5_15) {
                    block61: {
                        block77: {
                            block76: {
                                block75: {
                                    block74: {
                                        block73: {
                                            block72: {
                                                block71: {
                                                    state = Updater.state;
                                                    if (!args[1].equals("check")) break block71;
                                                    switch (SkriptCommand.$SWITCH_TABLE$ch$njol$skript$Updater$UpdateState()[state.ordinal()]) {
                                                        case 1: {
                                                            Updater.check(sender, false, false);
                                                            break;
                                                        }
                                                        case 2: {
                                                            Skript.info(sender, "" + Updater.m_check_in_progress);
                                                            break;
                                                        }
                                                        case 3: {
                                                            Updater.check(sender, false, false);
                                                            break;
                                                        }
                                                        case 4: {
                                                            if (Updater.latest == null) {
                                                                Skript.info(sender, "" + Updater.m_running_latest_version);
                                                                break;
                                                            }
                                                            Skript.info(sender, "" + Updater.m_update_available);
                                                            break;
                                                        }
                                                        case 5: {
                                                            Skript.info(sender, "" + Updater.m_download_in_progress);
                                                            break;
                                                        }
                                                        case 6: {
                                                            Skript.info(sender, "" + Updater.m_download_error);
                                                            break;
                                                        }
                                                        case 7: {
                                                            Skript.info(sender, "" + Updater.m_downloaded);
                                                        }
                                                    }
                                                    break block60;
                                                }
                                                if (!args[1].equalsIgnoreCase("changes")) ** GOTO lbl233
                                                if (state != Updater.UpdateState.NOT_STARTED) break block72;
                                                Skript.info(sender, "" + Updater.m_not_started);
                                                break block60;
                                            }
                                            if (state != Updater.UpdateState.CHECK_IN_PROGRESS) break block73;
                                            Skript.info(sender, "" + Updater.m_check_in_progress);
                                            break block60;
                                        }
                                        if (state != Updater.UpdateState.CHECK_ERROR) break block74;
                                        Skript.info(sender, "" + Updater.m_check_error);
                                        break block60;
                                    }
                                    if (Updater.latest != null) break block75;
                                    Skript.info(sender, "" + Updater.m_running_latest_version);
                                    break block60;
                                }
                                if (args.length != 2 || Updater.infos.size() == 1) break block76;
                                Skript.info(sender, "There have been " + Updater.infos.size() + " updates since your version:");
                                versions = Updater.infos.get((int)0).version.toString();
                                i = Updater.infos.size() - 1;
                                while (i >= 0) {
                                    versions = String.valueOf(versions) + ", " + Updater.infos.get((int)i).version.toString();
                                    --i;
                                }
                                Skript.message(sender, "  " + versions);
                                Skript.message(sender, "To show the changelog of a version type <gold>/skript update changes <version><reset>");
                                break block60;
                            }
                            info = null;
                            pageNum = 1;
                            if (Updater.infos.size() != 1) break block77;
                            info = Updater.latest.get();
                            if (args.length >= 3 && args[2].matches("\\d+")) {
                                pageNum = Skript.parseInt(args[2]);
                            }
                            ** GOTO lbl227
                        }
                        version = args[2];
                        for (Updater.VersionInfo i : Updater.infos) {
                            if (!i.version.toString().equals(version)) continue;
                            info = i;
                            break;
                        }
                        if (info != null) break block61;
                        Skript.error(sender, "No changelog for the version <gold>" + version + "<red> available");
                        return true;
                    }
                    if (args.length >= 4 && args[3].matches("\\d+")) {
                        pageNum = Skript.parseInt(args[3]);
                    }
lbl227:
                    // 4 sources

                    page = ChatPaginator.paginate((String)info.changelog, (int)pageNum, (int)55, (int)8);
                    Skript.info(sender, "<bold><cyan>" + info.version + "<reset> (" + info.date + ") <grey>[page " + pageNum + " of " + page.getTotalPages() + "]");
                    sender.sendMessage(page.getLines());
                    if (pageNum < page.getTotalPages()) {
                        Skript.message(sender, "<gray>type <gold>/skript update changes " + (Updater.infos.size() == 1 ? "" : info.version + " ") + (pageNum + 1) + "<gray> for the next page (hint: use the up arrow key)");
                    }
                    break block60;
lbl233:
                    // 1 sources

                    if (args[1].equalsIgnoreCase("download")) {
                        switch (SkriptCommand.$SWITCH_TABLE$ch$njol$skript$Updater$UpdateState()[state.ordinal()]) {
                            case 1: {
                                Updater.check(sender, true, false);
                                break;
                            }
                            case 2: {
                                Skript.info(sender, "" + Updater.m_check_in_progress);
                                break;
                            }
                            case 3: {
                                Updater.check(sender, true, false);
                                break;
                            }
                            case 4: {
                                if (Updater.latest == null) {
                                    Skript.info(sender, "" + Updater.m_running_latest_version);
                                    break;
                                }
                                Updater.download(sender, false);
                                break;
                            }
                            case 5: {
                                Skript.info(sender, "" + Updater.m_download_in_progress);
                                break;
                            }
                            case 7: {
                                Skript.info(sender, "" + Updater.m_downloaded);
                                break;
                            }
                            case 6: {
                                Skript.info(sender, "" + Updater.m_download_error);
                            }
                        }
                    }
                }
            }
            if (args[0].equalsIgnoreCase("help")) {
                SkriptCommand.skriptCommandHelp.showHelp(sender);
            }
        }
        return true;
    }

    private static File getScriptFromArgs(CommandSender sender, String[] args, int start) {
        File f;
        String script = StringUtils.join(args, " ", start, args.length);
        if (!script.endsWith(".sk")) {
            script = String.valueOf(script) + ".sk";
        }
        if (script.startsWith("-")) {
            script = script.substring(1);
        }
        if (!(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + script)).exists() && !(f = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator + "-" + script)).exists()) {
            Skript.error(sender, "Can't find the script <grey>'<gold>" + script + "<grey>'<red> in the scripts folder!");
            return null;
        }
        return f;
    }

    private static final Collection<File> toggleScripts(final boolean enable) throws IOException {
        return FileUtils.renameAll(new File(Skript.getInstance().getDataFolder(), "scripts"), new Converter<String, String>(){

            @Override
            public String convert(String name) {
                if (name.startsWith("-") == enable) {
                    return enable ? name.substring(1) : "-" + name;
                }
                return null;
            }
        });
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState() {
        if ($SWITCH_TABLE$ch$njol$skript$Updater$UpdateState != null) {
            return $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState;
        }
        int[] nArray = new int[Updater.UpdateState.values().length];
        try {
            nArray[Updater.UpdateState.CHECKED_FOR_UPDATE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.CHECK_ERROR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.CHECK_IN_PROGRESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOADED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOAD_ERROR.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.DOWNLOAD_IN_PROGRESS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Updater.UpdateState.NOT_STARTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$njol$skript$Updater$UpdateState = nArray;
        return nArray;
    }
}

