/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Metrics;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.Updater;
import ch.njol.skript.Variables;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.data.BukkitClasses;
import ch.njol.skript.classes.data.BukkitEventValues;
import ch.njol.skript.classes.data.DefaultClasses;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.classes.data.DefaultConverters;
import ch.njol.skript.classes.data.SkriptClasses;
import ch.njol.skript.command.Commands;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.util.VariableString;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.SimpleLog;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.util.Checker;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.CheckedIterator;
import ch.njol.util.iterator.EnumerationIterable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Skript
extends JavaPlugin
implements Listener {
    private static Skript instance = null;
    private static boolean disabled = false;
    private static Version version = null;
    private static Version minecraftVersion = null;
    private static boolean runningCraftBukkit;
    private static Variables variables;
    public static final String SCRIPTSFOLDER = "scripts";
    public static final String quotesError = "Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".";
    public static final double EPSILON = 1.0E-10;
    public static final double EPSILON_MULT = 1.00001;
    public static final int MAXBLOCKID = 255;
    public static final int TARGETBLOCKMAXDISTANCE = 100;
    public static final int NUMBERACCURACY = 2;
    public static final Random random;
    static EventPriority defaultEventPriority;
    static boolean listenerEnabled;
    public static boolean acceptRegistrations;
    private static final HashMap<String, SkriptAddon> addons;
    private static SkriptAddon addon;
    private static final Collection<SyntaxElementInfo<? extends Condition>> conditions;
    private static final Collection<SyntaxElementInfo<? extends Effect>> effects;
    private static final Collection<SyntaxElementInfo<? extends Statement>> statements;
    private static final List<ExpressionInfo<?, ?>> expressions;
    private static final int[] expressionTypesStartIndices;
    private static final Collection<SkriptEvent.SkriptEventInfo<?>> events;
    private static final String EXCEPTION_PREFIX = "##!! ";
    static final String skriptPrefix;

    static {
        variables = null;
        random = new Random();
        defaultEventPriority = EventPriority.NORMAL;
        listenerEnabled = true;
        acceptRegistrations = true;
        addons = new HashMap();
        conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(20);
        effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(20);
        statements = new ArrayList<SyntaxElementInfo<? extends Statement>>(40);
        expressions = new ArrayList(30);
        expressionTypesStartIndices = new int[ExpressionType.values().length];
        events = new ArrayList(50);
        skriptPrefix = ChatColor.GRAY + "[" + ChatColor.GOLD + "Skript" + ChatColor.GRAY + "]" + ChatColor.RESET + " ";
    }

    public static Skript getInstance() {
        return instance;
    }

    public Skript() throws IllegalAccessException {
        if (instance != null) {
            throw new IllegalAccessException("Cannot create multiple instances of Skript!");
        }
        instance = this;
    }

    public static Version getVersion() {
        return version;
    }

    public void onEnable() {
        if (disabled) {
            throw new IllegalStateException("Skript may only be reloaded by either Bukkit's '/reload' or Skript's '/skript reload' command");
        }
        Language.loadDefault(Skript.getAddonInstance());
        this.getFile();
        version = new Version(this.getDescription().getVersion());
        runningCraftBukkit = Bukkit.getServer().getClass().getName().equals("org.bukkit.craftbukkit.CraftServer");
        String bukkitV = Bukkit.getBukkitVersion();
        Matcher m = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?").matcher(bukkitV);
        if (!m.find()) {
            Skript.error("The Bukkit version '" + Bukkit.getBukkitVersion() + "' does not contain a version number which is required for Skript to enable or disable certain features. Skript will now disable itself.");
            this.setEnabled(false);
            return;
        }
        minecraftVersion = new Version(m.group());
        this.getCommand("skript").setExecutor((CommandExecutor)new SkriptCommand());
        new DefaultClasses();
        new BukkitClasses();
        new BukkitEventValues();
        new SkriptClasses();
        new DefaultComparators();
        new DefaultConverters();
        try {
            Skript.getAddonInstance().loadClasses("ch.njol.skript", "conditions", "effects", "events", "expressions", "entity");
        }
        catch (Exception e) {
            Skript.exception(e, "could not load required .class files: " + e.getLocalizedMessage());
            this.setEnabled(false);
            return;
        }
        if (!this.getDataFolder().isDirectory()) {
            this.getDataFolder().mkdirs();
        }
        SkriptConfig.load();
        if (SkriptConfig.checkForNewVersion) {
            Updater.check((CommandSender)Bukkit.getConsoleSender(), SkriptConfig.automaticallyDownloadNewVersion, true);
        }
        Aliases.load();
        Commands.registerListener();
        if (Skript.logNormal()) {
            Skript.info(" ~ created by & \u00a9 Peter G\u00fcttinger aka Njol ~");
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Skript.stopAcceptingRegistrations();
                Skript.variables = new Variables();
                SimpleLog log = SkriptLogger.startSubLog();
                if (!variables.loadVariables()) {
                    log.stop();
                    Skript.logEx();
                    Skript.logEx(new String[]{"===!!!=== Skript variable load error ===!!!==="});
                    Skript.logEx(new String[]{"Unable to load variables" + (log.size() == 0 ? "!" : ":")});
                    for (LogEntry e : log.getLog()) {
                        Skript.logEx(new String[]{e.getMessage()});
                    }
                    Skript.logEx();
                    Skript.logEx(new String[]{"Skript will work properly, but old variables will not be available at all and new ones will not be saved until Skript is able to create a backup of the old file!"});
                    Skript.logEx();
                } else {
                    log.printLog();
                }
                ScriptLoader.loadScripts();
                Skript.info("Skript finished loading!");
                try {
                    Metrics m = new Metrics((Plugin)Skript.this);
                    Metrics.Graph scriptData = m.createGraph("data");
                    scriptData.addPlotter(new Metrics.Plotter(Skript.SCRIPTSFOLDER){

                        @Override
                        public int getValue() {
                            return ScriptLoader.loadedScripts();
                        }
                    });
                    scriptData.addPlotter(new Metrics.Plotter("triggers"){

                        @Override
                        public int getValue() {
                            return ScriptLoader.loadedTriggers();
                        }
                    });
                    scriptData.addPlotter(new Metrics.Plotter("commands"){

                        @Override
                        public int getValue() {
                            return ScriptLoader.loadedCommands();
                        }
                    });
                    scriptData.addPlotter(new Metrics.Plotter("variables"){

                        @Override
                        public int getValue() {
                            return variables.numVariables();
                        }
                    });
                    Metrics.Graph language = m.createGraph("language");
                    language.addPlotter(new Metrics.Plotter(){

                        @Override
                        public int getValue() {
                            return 1;
                        }

                        @Override
                        public String getColumnName() {
                            return Language.getName();
                        }
                    });
                    Metrics.Graph similarPlugins = m.createGraph("similar plugins");
                    String[] stringArray = new String[]{"VariableTriggers", "rTriggers", "kTriggers", "TriggerCmds", "BlockScripts", "ScriptBlock", "buscript", "BukkitScript"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final String plugin = stringArray[n2];
                        similarPlugins.addPlotter(new Metrics.Plotter(plugin){

                            @Override
                            public int getValue() {
                                return Bukkit.getPluginManager().getPlugin(plugin) != null ? 1 : 0;
                            }
                        });
                        ++n2;
                    }
                    m.start();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        if (Bukkit.getOnlineMode()) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onJoin(PlayerJoinEvent e) {
                    if (e.getPlayer().getName().equalsIgnoreCase("Njol")) {
                        Skript.info((CommandSender)e.getPlayer(), "This server is running Skript " + Skript.this.getDescription().getVersion() + " =3");
                    }
                }
            }, (Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(final PlayerJoinEvent e) {
                if (e.getPlayer().hasPermission("skript.admin")) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.this, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = Updater.stateLock;
                            synchronized (object) {
                                if ((Updater.state == Updater.UpdateState.CHECKED_FOR_UPDATE || Updater.state == Updater.UpdateState.DOWNLOAD_ERROR) && Updater.latest != null) {
                                    Skript.info((CommandSender)e.getPlayer(), "" + Updater.m_update_available);
                                }
                            }
                        }
                    });
                }
            }
        }, (Plugin)this);
    }

    public static Version getMinecraftVersion() {
        return minecraftVersion;
    }

    public static boolean isRunningCraftBukkit() {
        return runningCraftBukkit;
    }

    public static boolean isRunningBukkit(int major, int minor) {
        return minecraftVersion.compareTo(major, minor) >= 0;
    }

    public static boolean isRunningBukkit(int major, int minor, int revision) {
        return minecraftVersion.compareTo(major, minor, revision) >= 0;
    }

    public static Variables getVariables() {
        return variables;
    }

    static final void disableScripts() {
        for (Trigger t : ScriptLoader.selfRegisteredTriggers) {
            ((SelfRegisteringSkriptEvent)t.getEvent()).unregisterAll();
        }
        ScriptLoader.selfRegisteredTriggers.clear();
        VariableString.variableNames.clear();
        SkriptEventHandler.triggers.clear();
        Commands.clearCommands();
    }

    static final void reload() {
        Skript.disableScripts();
        Skript.reloadMainConfig();
        Skript.reloadAliases();
        ScriptLoader.loadScripts();
    }

    static final void reloadScripts() {
        Skript.disableScripts();
        ScriptLoader.loadScripts();
    }

    static final void reloadMainConfig() {
        SkriptConfig.load();
    }

    static final void reloadAliases() {
        Aliases.clear();
        Aliases.load();
    }

    public void onDisable() {
        if (disabled) {
            return;
        }
        disabled = true;
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        variables.saveVariables(true);
        Skript.disableScripts();
        new Thread(new Runnable(){

            @Override
            public void run() {
                block14: {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        JarFile jar = new JarFile(Skript.this.getFile());
                        try {
                            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                                if (!e.getName().endsWith(".class")) continue;
                                try {
                                    Class<?> c = Class.forName(e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length()), false, Skript.this.getClassLoader());
                                    Field[] fieldArray = c.getDeclaredFields();
                                    int n = fieldArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Field f = fieldArray[n2];
                                        if (Modifier.isStatic(f.getModifiers()) && !f.getType().isPrimitive()) {
                                            if (Modifier.isFinal(f.getModifiers())) {
                                                modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                                            }
                                            f.setAccessible(true);
                                            f.set(null, null);
                                        }
                                        ++n2;
                                    }
                                }
                                catch (Throwable ex) {
                                    if (!$assertionsDisabled && !(ex instanceof NoClassDefFoundError)) {
                                        throw new AssertionError();
                                    }
                                }
                            }
                        }
                        finally {
                            jar.close();
                        }
                    }
                    catch (Throwable ex) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
            }
        }).start();
    }

    public static void outdatedError() {
        Skript.error("Skript v" + instance.getDescription().getVersion() + " is not fully compatible with Bukkit " + Bukkit.getVersion() + ". Some feature(s) will be broken until you update Skript.");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        e.printStackTrace();
    }

    public static EventPriority getDefaultEventPriority() {
        return defaultEventPriority;
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    public static final int parseInt(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public static final long parseLong(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    public static final String toString(double n) {
        return StringUtils.toString(n, 2);
    }

    public static void disableListener() {
        listenerEnabled = false;
    }

    public static void enableListener() {
        listenerEnabled = true;
    }

    public static void checkAcceptRegistrations() {
        if (!acceptRegistrations) {
            throw new SkriptAPIException("Registering is disabled after initialization!");
        }
    }

    private static void stopAcceptingRegistrations() {
        acceptRegistrations = false;
        Converters.createMissingConverters();
        Classes.sortClassInfos();
        if (Skript.debug()) {
            StringBuilder b = new StringBuilder();
            for (ClassInfo<?> ci : Classes.getClassInfos()) {
                if (b.length() != 0) {
                    b.append(", ");
                }
                b.append(ci.getCodeName());
            }
            Skript.info("All registered classes in order: " + b.toString());
        }
    }

    public static SkriptAddon registerAddon(JavaPlugin p) {
        Skript.checkAcceptRegistrations();
        if (addons.containsKey(p.getName())) {
            throw new IllegalArgumentException("The plugin " + p.getName() + " is already registered");
        }
        SkriptAddon addon = new SkriptAddon(p);
        addons.put(p.getName(), addon);
        return addon;
    }

    public static SkriptAddon getAddon(JavaPlugin p) {
        return addons.get(p.getName());
    }

    public static SkriptAddon getAddon(String name) {
        return addons.get(name);
    }

    public static Collection<SkriptAddon> getAddons() {
        return Collections.unmodifiableCollection(addons.values());
    }

    public static SkriptAddon getAddonInstance() {
        if (addon == null) {
            SkriptAddon a;
            addon = a = new SkriptAddon(Skript.getInstance()).setLanguageFileDirectory("lang");
        }
        return addon;
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, condition);
        conditions.add(info);
        statements.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, effect);
        effects.add(info);
        statements.add(info);
    }

    public static Collection<SyntaxElementInfo<? extends Statement>> getStatements() {
        return statements;
    }

    public static Collection<SyntaxElementInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<SyntaxElementInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> c, Class<T> returnType, ExpressionType type, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        ExpressionInfo<E, T> info = new ExpressionInfo<E, T>(patterns, returnType, c);
        int i = type.ordinal() + 1;
        while (i < ExpressionType.values().length) {
            int n = i++;
            expressionTypesStartIndices[n] = expressionTypesStartIndices[n] + 1;
        }
        expressions.add(expressionTypesStartIndices[type.ordinal()], info);
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions() {
        return expressions.iterator();
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions(final Class<?> ... returnTypes) {
        return new CheckedIterator(expressions.iterator(), new Checker<ExpressionInfo<?, ?>>(){

            @Override
            public boolean check(ExpressionInfo<?, ?> i) {
                if (i.returnType == Object.class) {
                    return true;
                }
                Class[] classArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class returnType = classArray[n2];
                    if (Converters.converterExists(i.returnType, returnType)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event> event, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, Skript.array(event)));
    }

    public static <E extends SkriptEvent> void registerEvent(Class<E> c, Class<? extends Event>[] events, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        Skript.events.add(new SkriptEvent.SkriptEventInfo<E>(patterns, c, events));
    }

    public static final Collection<SkriptEvent.SkriptEventInfo<?>> getEvents() {
        return events;
    }

    public static final boolean dispatchCommand(CommandSender sender, String command) {
        if (sender instanceof Player) {
            PlayerCommandPreprocessEvent e = new PlayerCommandPreprocessEvent((Player)sender, "/" + command);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.isCancelled() || !e.getMessage().startsWith("/")) {
                return false;
            }
            return Bukkit.dispatchCommand((CommandSender)e.getPlayer(), (String)e.getMessage().substring(1));
        }
        ServerCommandEvent e = new ServerCommandEvent(sender, command);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.getCommand() == null || e.getCommand().isEmpty()) {
            return false;
        }
        return Bukkit.dispatchCommand((CommandSender)e.getSender(), (String)e.getCommand());
    }

    public static final boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static final boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static final boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static final boolean debug() {
        return SkriptLogger.debug();
    }

    public static final boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void config(String info) {
        SkriptLogger.log(Level.CONFIG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static void warning(String warning) {
        SkriptLogger.log(Level.WARNING, warning);
    }

    public static void error(String error) {
        SkriptLogger.log(Level.SEVERE, error);
    }

    public static void error(String error, ErrorQuality quality) {
        SkriptLogger.error(new LogEntry(Level.SEVERE, error), quality);
    }

    public static final RuntimeException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static final EmptyStackException exception(Throwable cause, String ... info) {
        Skript.logEx();
        Skript.logEx("[Skript] Severe Error:");
        Skript.logEx(info);
        Skript.logEx();
        Skript.logEx("If you're developping an add-on for Skript this likely means that you have done something wrong.");
        Skript.logEx("If you're a server admin however please go to http://dev.bukkit.org/server-mods/skript/tickets/");
        Skript.logEx("and check whether this error has already been reported.");
        Skript.logEx("If not please create a new ticket with a meaningful title, copy & paste this whole error into it,");
        Skript.logEx("and describe what you did before it happened and/or what you think caused the error.");
        Skript.logEx("If you feel like it's a trigger that's causing the error please post the trigger as well.");
        Skript.logEx("By following this guide fixing the error should be easy and done fast.");
        Skript.logEx();
        Skript.logEx("Stacktrace:");
        if (cause == null || cause.getStackTrace().length == 0) {
            Skript.logEx("  warning: no/empty exception given, dumping current stack trace instead");
            cause = new Exception(cause);
        }
        Skript.logEx(cause.toString());
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            Skript.logEx("    at " + e.toString());
            ++n2;
        }
        Skript.logEx();
        Skript.logEx("Version Information:");
        Skript.logEx("  Skript: " + Skript.getInstance().getDescription().getVersion());
        Skript.logEx("  Bukkit: " + Bukkit.getBukkitVersion());
        Skript.logEx("  Java: " + System.getProperty("java.version"));
        Skript.logEx();
        Skript.logEx("Running CraftBukkit: " + runningCraftBukkit);
        Skript.logEx();
        Skript.logEx("Current node: " + SkriptLogger.getNode());
        Skript.logEx();
        Skript.logEx("Current thread: " + Thread.currentThread().getName());
        Skript.logEx();
        Skript.logEx("End of Error.");
        Skript.logEx();
        return new EmptyStackException();
    }

    private static final void logEx() {
        Bukkit.getLogger().severe(EXCEPTION_PREFIX);
    }

    private static final void logEx(String ... lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Bukkit.getLogger().severe(EXCEPTION_PREFIX + line);
            ++n2;
        }
    }

    public static void info(CommandSender sender, String info) {
        sender.sendMessage(String.valueOf(skriptPrefix) + Utils.replaceEnglishChatStyles(info));
    }

    public static void broadcast(String message, String permission) {
        Bukkit.broadcast((String)(String.valueOf(skriptPrefix) + Utils.replaceEnglishChatStyles(message)), (String)permission);
    }

    public static void adminBroadcast(String message) {
        Bukkit.broadcast((String)(String.valueOf(skriptPrefix) + Utils.replaceEnglishChatStyles(message)), (String)"skript.admin");
    }

    public static void message(CommandSender sender, String info) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(info));
    }

    public static void error(CommandSender sender, String error) {
        sender.sendMessage(String.valueOf(skriptPrefix) + ChatColor.DARK_RED + Utils.replaceEnglishChatStyles(error));
    }

    public static String getSyntaxElementName(Class<? extends SyntaxElement> c) {
        if (Condition.class.isAssignableFrom(c)) {
            return "condition";
        }
        if (Effect.class.isAssignableFrom(c)) {
            return "effect";
        }
        if (Expression.class.isAssignableFrom(c)) {
            return "expression";
        }
        return "syntax element";
    }
}

