/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Aliases;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.While;
import ch.njol.skript.localization.Language;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.ItemType;
import ch.njol.util.Callback;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class ScriptLoader {
    public static Config currentScript = null;
    public static SkriptEvent currentEvent = null;
    public static Class<? extends Event>[] currentEvents = null;
    public static List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    public static List<Loop> currentLoops = new ArrayList<Loop>();
    public static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    public static final HashMap<String, String> currentOptions = new HashMap();
    private static volatile ScriptInfo loadedScripts = new ScriptInfo();
    public static Kleenean hasDelayBefore = Kleenean.FALSE;
    private static String indentation = "";
    static final List<Trigger> selfRegisteredTriggers = new ArrayList<Trigger>();
    private static final Set<Class<? extends Event>> registeredEvents = new HashSet<Class<? extends Event>>();

    private ScriptLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScriptInfo loadScripts() {
        ScriptInfo i;
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separatorChar);
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        int startErrors = SkriptLogger.getNumErrors();
        Date start = new Date();
        Language.setUseLocal(false);
        try {
            i = ScriptLoader.loadScripts(scriptsFolder);
        }
        finally {
            Language.setUseLocal(true);
        }
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.add(i);
        }
        if (startErrors == SkriptLogger.getNumErrors()) {
            Skript.info("All scripts loaded without errors!");
        }
        if (i.files == 0) {
            Skript.warning("No scripts were found, maybe you should write some ;)");
        }
        if (Skript.logNormal() && i.files > 0) {
            Skript.info("loaded " + i.files + " script" + (i.files == 1 ? "" : "s") + " with a total of " + i.triggers + " trigger" + (i.triggers == 1 ? "" : "s") + " and " + i.commands + " command" + (i.commands == 1 ? "" : "s") + " in " + start.difference(new Date()));
        }
        ScriptLoader.registerBukkitEvents();
        return i;
    }

    private static final ScriptInfo loadScripts(File directory) {
        ScriptInfo i = new ScriptInfo();
        File[] fileArray = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return (f.isDirectory() || f.getName().endsWith(".sk")) && !f.getName().startsWith("-");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                i.add(ScriptLoader.loadScripts(f));
            } else {
                i.add(ScriptLoader.loadScript(f));
            }
            ++n2;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ScriptInfo loadScripts(Collection<File> files) {
        ScriptInfo i = new ScriptInfo();
        Language.setUseLocal(false);
        try {
            for (File f : files) {
                i.add(ScriptLoader.loadScript(f));
            }
        }
        finally {
            Language.setUseLocal(true);
        }
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.add(i);
        }
        ScriptLoader.registerBukkitEvents();
        return i;
    }

    /*
     * Unable to fully structure code
     */
    private static final ScriptInfo loadScript(File f) {
        cache = null;
        if (SkriptConfig.enableScriptCaching && (cache = new File(f.getParentFile(), "cache" + File.separator + f.getName() + "c")).exists()) {
            block68: {
                block69: {
                    log = SkriptLogger.startSubLog();
                    in = null;
                    in = new ObjectInputStream(new FileInputStream(cache));
                    lastModified = in.readLong();
                    if (lastModified != f.lastModified()) break block68;
                    script = (SerializedScript)in.readObject();
                    block29: for (Trigger t : script.triggers) {
                        if (t.getEvent() instanceof SelfRegisteringSkriptEvent) {
                            ((SelfRegisteringSkriptEvent)t.getEvent()).register(t);
                            ScriptLoader.selfRegisteredTriggers.add(t);
                            continue;
                        }
                        for (SkriptEvent.SkriptEventInfo<?> e : Skript.getEvents()) {
                            if (e.c != t.getEvent().getClass()) continue;
                            SkriptEventHandler.addTrigger(e.events, t);
                            continue block29;
                        }
                        throw new EmptyStackException();
                    }
                    for (ScriptCommand c : script.commands) {
                        Commands.registerCommand(c);
                    }
                    log.printLog();
                    var12_23 = new ScriptInfo(1, script.triggers.size(), script.commands.size());
                    log.stop();
                    if (in == null) break block69;
                    try {
                        in.close();
                    }
                    catch (IOException var13_25) {
                        // empty catch block
                    }
                }
                return var12_23;
            }
            try {
                try {
                    cache.delete();
                }
                catch (Exception e) {
                    if (Skript.debug()) {
                        System.err.println("[debug] Error loading cached script '" + f.getName() + "':");
                        e.printStackTrace();
                    }
                    ScriptLoader.unloadScript(f);
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException var5_30) {
                            // empty catch block
                        }
                    }
                    cache.delete();
                    log.stop();
                    if (in == null) ** GOTO lbl79
                    try {
                        in.close();
                    }
                    catch (IOException var13_26) {}
                }
            }
            catch (Throwable var11_32) {
                log.stop();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException var13_27) {
                        // empty catch block
                    }
                }
                throw var11_32;
            }
            log.stop();
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var13_28) {
                    // empty catch block
                }
            }
        }
lbl79:
        // 9 sources

        try {
            block71: {
                config = new Config(f, true, false, ":");
                if (SkriptConfig.keepConfigsLoaded) {
                    SkriptConfig.configs.add(config);
                }
                numTriggers = 0;
                numCommands = 0;
                numErrors = SkriptLogger.getNumErrors();
                ScriptLoader.currentAliases.clear();
                ScriptLoader.currentOptions.clear();
                ScriptLoader.currentScript = config;
                script = new SerializedScript();
                for (Node cnode : config.getMainNode()) {
                    if (!(cnode instanceof SectionNode)) {
                        Skript.error("invalid line - all code has to be put into triggers");
                        continue;
                    }
                    node = (SectionNode)cnode;
                    event = node.getName();
                    if (event.equalsIgnoreCase("aliases")) {
                        node.convertToEntries(0, "=");
                        for (Node n : node) {
                            if (!(n instanceof EntryNode)) {
                                Skript.error("invalid line in alias section");
                                continue;
                            }
                            t = Aliases.parseAlias(((EntryNode)n).getValue());
                            if (t == null) continue;
                            ScriptLoader.currentAliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("options")) {
                        node.convertToEntries(0);
                        for (Node n : node) {
                            if (!(n instanceof EntryNode)) {
                                Skript.error("invalid line in options");
                                continue;
                            }
                            ScriptLoader.currentOptions.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                        }
                        continue;
                    }
                    if (event.equalsIgnoreCase("variables")) {
                        node.convertToEntries(0, "=");
                        for (Node n : node) {
                            if (!(n instanceof EntryNode)) {
                                Skript.error("invalid line in variables");
                                continue;
                            }
                            name = ((EntryNode)n).getKey();
                            if (name.startsWith("{") && name.endsWith("}")) {
                                name = name.substring(1, name.length() - 1);
                            }
                            if ((name = StringUtils.replaceAll(name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                                private final /* synthetic */ String val$var;
                                {
                                    this.val$var = string;
                                }

                                @Override
                                public String run(Matcher m) {
                                    if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                        Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                        return null;
                                    }
                                    ClassInfo<?> ci = Classes.getClassInfoFromUserInput(m.group(1));
                                    if (ci == null) {
                                        Skript.error("Can't understand the type '" + m.group(1) + "'");
                                        return null;
                                    }
                                    return "<" + ci.getCodeName() + ">";
                                }
                            })) == null || name.contains("%") || Skript.getVariables().getVariable(Variable.splitVariableName(name)) != null) continue;
                            log = SkriptLogger.startSubLog();
                            o = Classes.parseSimple(((EntryNode)n).getValue(), Object.class, ParseContext.CONFIG);
                            log.stop();
                            if (o == null) {
                                log.printErrors("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                                continue;
                            }
                            ci = Classes.getSuperClassInfo(o.getClass());
                            if (ci.getSerializeAs() != null) {
                                as = Classes.getSuperClassInfo(ci.getSerializeAs());
                                if (as == null) {
                                    Skript.error("Missing class info for " + ci.getSerializeAs().getName() + ", the class to serialize " + ci.getC().getName() + " as");
                                    continue;
                                }
                                if ((o = Converters.convert(o, as.getC())) == null) {
                                    Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                                    continue;
                                }
                            }
                            Skript.getVariables().setVariable(Variable.splitVariableName(name), o);
                        }
                        continue;
                    }
                    if (StringUtils.count(event, '\"') % 2 != 0) {
                        Skript.error("Invalid use of quotes (\"). If you want to use quotes in \"quoted text\", double them: \"\".");
                        continue;
                    }
                    if (event.toLowerCase().startsWith("command ")) {
                        ScriptLoader.currentEvent = null;
                        ScriptLoader.currentEvents = Skript.array(new Class[]{CommandEvent.class});
                        c = Commands.loadCommand(node);
                        if (c == null) continue;
                        ++numCommands;
                        script.commands.add(c);
                        continue;
                    }
                    if (Skript.logVeryHigh() && !Skript.debug()) {
                        Skript.info("loading trigger '" + event + "'");
                    }
                    if (StringUtils.startsWithIgnoreCase(event, "on ")) {
                        event = event.substring("on ".length());
                    }
                    if ((event = ScriptLoader.replaceOptions(event)) == null || (parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'")) == null) continue;
                    if (Skript.debug()) {
                        Skript.info(String.valueOf(event) + " (" + ((SkriptEvent)parsedEvent.second).toString(null, true) + "):");
                    }
                    ScriptLoader.currentEvent = (SkriptEvent)parsedEvent.second;
                    ScriptLoader.currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
                    ScriptLoader.hasDelayBefore = Kleenean.FALSE;
                    trigger = new Trigger(config.getFile(), event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
                    ScriptLoader.currentEvent = null;
                    ScriptLoader.currentEvents = null;
                    ScriptLoader.hasDelayBefore = Kleenean.FALSE;
                    if (parsedEvent.second instanceof SelfRegisteringSkriptEvent) {
                        ((SelfRegisteringSkriptEvent)parsedEvent.second).register(trigger);
                        ScriptLoader.selfRegisteredTriggers.add(trigger);
                    } else {
                        SkriptEventHandler.addTrigger(((SkriptEvent.SkriptEventInfo)parsedEvent.first).events, trigger);
                    }
                    script.triggers.add(trigger);
                    ++numTriggers;
                }
                if (Skript.logHigh()) {
                    Skript.info("loaded " + numTriggers + " trigger" + (numTriggers == 1 ? "" : "s") + " and " + numCommands + " command" + (numCommands == 1 ? "" : "s") + " from '" + config.getFileName() + "'");
                }
                ScriptLoader.currentScript = null;
                if (SkriptConfig.enableScriptCaching && numErrors == SkriptLogger.getNumErrors()) {
                    out = null;
                    try {
                        cache.getParentFile().mkdirs();
                        out = new ObjectOutputStream(new FileOutputStream(cache));
                        out.writeLong(f.lastModified());
                        out.writeObject(script);
                    }
                    catch (NotSerializableException e) {
                        Skript.exception(e, new String[]{"Cannot cache " + f.getName()});
                        if (out != null) {
                            out.close();
                        }
                        cache.delete();
                        if (out != null) {
                            out.close();
                        }
                        break block71;
                    }
                    catch (IOException e) {
                        try {
                            Skript.warning("Cannot cache " + f.getName() + ": " + e.getLocalizedMessage());
                            if (out != null) {
                                out.close();
                            }
                            cache.delete();
                            break block71;
                        }
                        catch (Throwable var9_20) {
                            throw var9_20;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    if (out == null) break block71;
                    out.close();
                }
            }
            var20_39 = new ScriptInfo(1, numTriggers, numCommands);
            return var20_39;
        }
        catch (IOException e) {
            Skript.error("Could not load " + f.getName() + ": " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            Skript.exception(e, new String[]{"Could not load " + f.getName()});
        }
        finally {
            SkriptLogger.setNode(null);
        }
        return new ScriptInfo();
    }

    private static final void registerBukkitEvents() {
        for (Class<? extends Event> e : SkriptEventHandler.triggers.keySet()) {
            if (registeredEvents.contains(e)) continue;
            Bukkit.getPluginManager().registerEvent(e, new Listener(){}, Skript.defaultEventPriority, SkriptEventHandler.ee, (Plugin)Skript.getInstance());
            registeredEvents.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final ScriptInfo unloadScript(File script) {
        ScriptInfo info = new ScriptInfo();
        Iterator<List<Trigger>> triggersIter = SkriptEventHandler.triggers.values().iterator();
        while (triggersIter.hasNext()) {
            List<Trigger> ts = triggersIter.next();
            int i = 0;
            while (i < ts.size()) {
                if (ts.get(i).getScript().equals(script)) {
                    ++info.triggers;
                    ts.remove(i);
                    --i;
                    if (ts.isEmpty()) {
                        triggersIter.remove();
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < selfRegisteredTriggers.size()) {
            Trigger t = selfRegisteredTriggers.get(i);
            if (t.getScript().equals(script)) {
                ++info.triggers;
                ((SelfRegisteringSkriptEvent)t.getEvent()).unregister(t);
                selfRegisteredTriggers.remove(i);
                --i;
            }
            ++i;
        }
        info.commands = Commands.unregisterCommands(script);
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.subtract(info);
        }
        return info;
    }

    private static final String replaceOptions(String s) {
        return StringUtils.replaceAll(s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                String option = currentOptions.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return null;
                }
                return option;
            }
        });
    }

    public static ArrayList<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            indentation = String.valueOf(indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        Kleenean hadDelayBeforeLastIf = Kleenean.FALSE;
        for (Node n : node) {
            Condition cond;
            Kleenean hadDelayBefore;
            String l;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String ex = ScriptLoader.replaceOptions(e.getName());
                if (ex == null || (stmt = Statement.parse(ex, "can't understand this condition/effect: " + ex)) == null) continue;
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                hasDelayBefore = Kleenean.TRUE;
                continue;
            }
            if (!(n instanceof SectionNode)) continue;
            if (StringUtils.startsWithIgnoreCase(n.getName(), "loop ")) {
                Expression<Object> loopedExpr;
                l = ScriptLoader.replaceOptions(n.getName().substring("loop ".length()));
                if (l == null || (loopedExpr = SkriptParser.parseExpression(l, false, ParseContext.DEFAULT, Object.class).getConvertedExpression(Object.class)) == null) continue;
                if (loopedExpr.isSingle()) {
                    Skript.error("Can't loop " + loopedExpr);
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                hadDelayBefore = hasDelayBefore;
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
                hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(n.getName(), "while ")) {
                Condition c;
                l = ScriptLoader.replaceOptions(n.getName().substring("while ".length()));
                if (l == null || (c = Condition.parse(l, "Can't understand this condition: " + l)) == null) continue;
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "while " + c.toString(null, true) + ":");
                }
                hadDelayBefore = hasDelayBefore;
                items.add(new While(c, (SectionNode)n));
                if (hadDelayBefore == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
                hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (n.getName().equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional)) {
                    Skript.error("'else' has to be placed just after the end of a conditional section");
                    continue;
                }
                if (Skript.debug()) {
                    Skript.info(String.valueOf(indentation) + "else:");
                }
                Kleenean hadDelayAfterLastIf = hasDelayBefore;
                hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                hasDelayBefore = hasDelayBefore.and(hadDelayAfterLastIf).or(hadDelayBeforeLastIf);
                continue;
            }
            String name = n.getName();
            if (StringUtils.startsWithIgnoreCase(name, "if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug()) {
                Skript.info(String.valueOf(indentation) + cond.toString(null, true) + ":");
            }
            hadDelayBeforeLastIf = hadDelayBefore = hasDelayBefore;
            items.add(new Conditional(cond, (SectionNode)n));
            if (hadDelayBefore == Kleenean.TRUE || hasDelayBefore == Kleenean.FALSE) continue;
            hasDelayBefore = Kleenean.UNKNOWN;
        }
        int i = 0;
        while (i < items.size() - 1) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
            ++i;
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            indentation = indentation.substring(0, indentation.length() - 4);
        }
        return items;
    }

    static Trigger loadTrigger(SectionNode node) {
        String event = node.getName();
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        Pair<SkriptEvent.SkriptEventInfo<?>, SkriptEvent> parsedEvent = SkriptParser.parseEvent(event, "can't understand this event: '" + node.getName() + "'");
        currentEvent = (SkriptEvent)parsedEvent.second;
        currentEvents = ((SkriptEvent.SkriptEventInfo)parsedEvent.first).events;
        Trigger t = new Trigger(null, event, (SkriptEvent)parsedEvent.second, ScriptLoader.loadItems(node));
        currentEvent = null;
        currentEvents = null;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedScripts() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedCommands() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedTriggers() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.triggers;
        }
    }

    public static class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.triggers -= other.triggers;
            this.commands -= other.commands;
        }
    }

    private static final class SerializedScript
    implements Serializable {
        static final long serialVersionUID = -6209530262798192214L;
        public final List<Trigger> triggers = new ArrayList<Trigger>();
        public final List<ScriptCommand> commands = new ArrayList<ScriptCommand>();

        private SerializedScript() {
        }
    }
}

