/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util.iterator;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ListRangeIterator<T>
implements Iterator<T> {
    private final ListIterator<T> iter;
    private int end;

    public ListRangeIterator(List<T> list, int start, int end) {
        this.iter = list.listIterator(start);
        this.end = end;
    }

    @Override
    public boolean hasNext() {
        return this.iter.nextIndex() < this.end;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.iter.remove();
        --this.end;
    }
}

