/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import ch.njol.util.Reference;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SynchronizedReference<T>
extends Reference<T> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public SynchronizedReference() {
    }

    public SynchronizedReference(T value) {
        super(value);
    }

    @Override
    public T get() {
        this.lock.readLock().lock();
        try {
            Object t = super.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void set(T value) {
        this.lock.writeLock().lock();
        try {
            super.set(value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object obj) {
        this.lock.readLock().lock();
        try {
            boolean bl = super.equals(obj);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int hashCode() {
        this.lock.readLock().lock();
        try {
            int n = super.hashCode();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

