/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import ch.njol.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class CollectionUtils {
    private static final Random random = new Random();

    private CollectionUtils() {
    }

    public static <T> int indexOf(T[] array, T t) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == null ? t == null : array[i].equals(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T t, int start, int end) {
        if (array == null) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (array[i] == null ? t == null : array[i].equals(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T o) {
        return CollectionUtils.indexOf(array, o) != -1;
    }

    public static <T> boolean containsAny(T[] array, T ... os) {
        if (array == null || os == null) {
            return false;
        }
        T[] TArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (CollectionUtils.indexOf(array, o) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... os) {
        if (array == null || os == null) {
            return false;
        }
        T[] TArray = os;
        int n = os.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (CollectionUtils.indexOf(array, o) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int indexOf(int[] array, int num) {
        if (array == null) {
            return -1;
        }
        return CollectionUtils.indexOf(array, num, 0, array.length);
    }

    public static int indexOf(int[] array, int num, int start) {
        if (array == null) {
            return -1;
        }
        return CollectionUtils.indexOf(array, num, start, array.length);
    }

    public static int indexOf(int[] array, int num, int start, int end) {
        if (array == null) {
            return -1;
        }
        int i = start;
        while (i < end) {
            if (array[i] == num) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final boolean contains(int[] array, int num) {
        return CollectionUtils.indexOf(array, num) != -1;
    }

    public static int indexOfIgnoreCase(String[] array, String s) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
            ++n2;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(String[] array, String s) {
        return CollectionUtils.indexOfIgnoreCase(array, s) != -1;
    }

    public static <T> int indexOf(Iterable<T> iter, T o) {
        if (iter == null) {
            return -1;
        }
        int i = 0;
        for (T a : iter) {
            if (a.equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(Iterable<String> iter, String s) {
        if (iter == null) {
            return -1;
        }
        int i = 0;
        for (String a : iter) {
            if (a.equalsIgnoreCase(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, U> Map.Entry<T, U> containsKey(Map<T, U> map, T key) {
        if (map == null) {
            return null;
        }
        U u = map.get(key);
        if (u == null) {
            return null;
        }
        return new Pair<T, U>(key, u);
    }

    public static <U> Map.Entry<String, U> containsKeyIgnoreCase(Map<String, U> map, String key) {
        if (map == null) {
            return null;
        }
        for (Map.Entry<String, U> e : map.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(key)) continue;
            return e;
        }
        return null;
    }

    public static final boolean containsSuperclass(Class<?>[] classes, Class<?> c) {
        if (classes == null || c == null) {
            return false;
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            if (cl.isAssignableFrom(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean containsAnySuperclass(Class<?>[] classes, Class<?> ... cs) {
        if (classes == null || cs == null) {
            return false;
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            Class<?>[] classArray2 = cs;
            int n3 = cs.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> c = classArray2[n4];
                if (cl.isAssignableFrom(c)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static <T> T random(T[] os) {
        if (os == null || os.length == 0) {
            return null;
        }
        return os[random.nextInt(os.length)];
    }

    public static <T> T getRandom(T[] os, int start) {
        if (os == null || os.length == 0) {
            return null;
        }
        return os[random.nextInt(os.length - start) + start];
    }

    public static <T> T getRandom(List<T> os) {
        if (os == null || os.isEmpty()) {
            return null;
        }
        return os.get(random.nextInt(os.size()));
    }

    public static boolean isSubset(Object[] set, Object[] sub) {
        if (set == null || sub == null) {
            return false;
        }
        Object[] objectArray = set;
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            if (!CollectionUtils.contains(sub, s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final <E> Set<E> intersection(Set<E> ... sets) {
        if (sets == null || sets.length == 0) {
            return null;
        }
        if (sets.length == 1) {
            return sets[0];
        }
        HashSet<E> l = new HashSet<E>(sets[0]);
        int i = 1;
        while (i < sets.length) {
            l.retainAll(sets[i]);
            ++i;
        }
        return l;
    }

    public static final <E> Set<E> union(Set<E> ... sets) {
        if (sets == null || sets.length == 0) {
            return null;
        }
        if (sets.length == 1) {
            return sets[0];
        }
        HashSet<E> l = new HashSet<E>(sets[0]);
        int i = 1;
        while (i < sets.length) {
            l.addAll(sets[i]);
            ++i;
        }
        return l;
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    public static final int[] permutation(int start, int end) {
        int length = end - start + 1;
        int[] r = new int[length];
        int i = 0;
        while (i < length) {
            r[i] = start + i;
            ++i;
        }
        i = 0;
        while (i < length) {
            int j = random.nextInt(length);
            int b = r[i];
            r[i] = r[j];
            r[j] = b;
            ++i;
        }
        return r;
    }

    public static final int[] permutation(int length) {
        return CollectionUtils.permutation(0, length - 1);
    }
}

