/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util;

import ch.njol.util.BidiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BidiHashMap<T1, T2>
extends HashMap<T1, T2>
implements BidiMap<T1, T2> {
    private static final long serialVersionUID = -9011678701069901061L;
    private final BidiHashMap<T2, T1> other;

    private BidiHashMap(BidiHashMap<T2, T1> other) {
        this.other = other;
    }

    public BidiHashMap() {
        this.other = new BidiHashMap<T1, T2>(this);
    }

    public BidiHashMap(Map<? extends T1, ? extends T2> values) {
        this.other = new BidiHashMap<T1, T2>(this);
        this.putAll(values);
    }

    @Override
    public BidiHashMap<T2, T1> getReverseView() {
        return this.other;
    }

    @Override
    public T1 getKey(Object value) {
        return (T1)this.other.get(value);
    }

    @Override
    public T2 getValue(Object key) {
        return (T2)this.get(key);
    }

    private T2 putDirect(T1 key, T2 value) {
        return super.put(key, value);
    }

    @Override
    public T2 put(T1 key, T2 value) {
        T1 oldKey;
        if (key == null || value == null) {
            throw new NullPointerException("Can't store null in a BidiHashMap");
        }
        T2 oldValue = this.putDirect(key, value);
        if (oldValue != null && oldValue.equals(value)) {
            super.putDirect(value, key);
            return oldValue;
        }
        if (oldValue != null) {
            super.removeDirect(oldValue);
        }
        if ((oldKey = super.putDirect(value, key)) != null) {
            this.removeDirect(oldKey);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends T1, ? extends T2> m) {
        for (Map.Entry<T1, T2> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private T2 removeDirect(Object key) {
        return (T2)super.remove(key);
    }

    @Override
    public T2 remove(Object key) {
        T2 oldValue = this.removeDirect(key);
        if (oldValue != null) {
            super.removeDirect(oldValue);
        }
        return oldValue;
    }

    private void clearDirect() {
        super.clear();
    }

    @Override
    public void clear() {
        this.clearDirect();
        super.clearDirect();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.other.containsKey(value);
    }

    @Override
    public Collection<T2> values() {
        return this.other.keySet();
    }

    @Override
    public Set<T2> valueSet() {
        return this.other.keySet();
    }

    @Override
    public BidiHashMap<T1, T2> clone() {
        return new BidiHashMap<T1, T2>(this);
    }
}

