/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.variables;

import ch.njol.skript.Skript;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Pair;
import java.io.Closeable;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class VariablesStorage
implements Closeable {
    private static final int QUEUE_SIZE = 1000;
    private final LinkedBlockingQueue<Pair<String, Object>> changesQueue = new LinkedBlockingQueue(1000);
    protected boolean closed = false;
    private final Thread writeThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (!VariablesStorage.this.closed) {
                try {
                    Pair<String, String> data2;
                    Pair data = (Pair)VariablesStorage.this.changesQueue.take();
                    Pair<String, String> pair = data2 = data.second == null ? null : Classes.serialize(data.second);
                    if (data2 != null) {
                        VariablesStorage.this.save((String)data.first, (String)data2.first, (String)data2.second);
                        continue;
                    }
                    VariablesStorage.this.save((String)data.first, null, null);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    });
    private long lastWarning = Long.MIN_VALUE;

    public final boolean load() {
        if (!this.load_i()) {
            return false;
        }
        Skript.closeOnDisable(this);
        this.writeThread.start();
        return true;
    }

    protected abstract boolean load_i();

    final void save(String name, Object value) {
        if (!this.changesQueue.offer(new Pair<String, Object>(name, value))) {
            if (this.lastWarning < System.currentTimeMillis() - 10000L) {
                Skript.warning("Cannot write variables to the " + this.type() + " at sufficient speed; server performance will suffer and many variables will be lost if the server crashes. (this warning will be repeated at most once every 10 seconds)");
                this.lastWarning = System.currentTimeMillis();
            }
            while (true) {
                try {
                    this.changesQueue.put(new Pair<String, Object>(name, value));
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public void close() {
        while (this.changesQueue.size() > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.closed = true;
    }

    protected void clearChangesQueue() {
        this.changesQueue.clear();
    }

    protected abstract void save(String var1, String var2, String var3);

    protected abstract String type();
}

