/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.GeneralWords;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Utils;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Pair;
import java.io.Serializable;
import java.util.HashMap;

public class Timespan
implements Serializable {
    private static final Noun m_tick = new Noun("time.tick");
    private static final Noun m_second = new Noun("time.second");
    private static final Noun m_minute = new Noun("time.minute");
    private static final Noun m_hour = new Noun("time.hour");
    private static final Noun m_day = new Noun("time.day");
    private static final Noun[] names = new Noun[]{m_tick, m_second, m_minute, m_hour, m_day};
    private static final int[] times = new int[]{50, 1000, 60000, 3600000, 86400000};
    static final HashMap<String, Integer> parseValues = new HashMap();
    private final long millis;
    static final Pair<Noun, Integer>[] simpleValues;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                int i = 0;
                while (i < names.length) {
                    parseValues.put(names[i].getSingular(), times[i]);
                    parseValues.put(names[i].getPlural(), times[i]);
                    ++i;
                }
            }
        });
        simpleValues = new Pair[]{new Pair<Noun, Integer>(m_day, 86400000), new Pair<Noun, Integer>(m_hour, 3600000), new Pair<Noun, Integer>(m_minute, 60000), new Pair<Noun, Integer>(m_second, 1000)};
    }

    public static final Timespan parse(String s) {
        if (s.isEmpty()) {
            return null;
        }
        int t = 0;
        boolean minecraftTime = false;
        boolean isMinecraftTimeSet = false;
        if (s.matches("^\\d+:\\d\\d(:\\d\\d)?(\\.\\d{1,4})?$")) {
            String[] ss = s.split("[:.]");
            int[] times = new int[]{3600000, 60000, 1000, 1};
            int offset = ss.length == 3 && !s.contains(".") || ss.length == 4 ? 1 : 0;
            int i = 0;
            while (i < ss.length) {
                t += times[offset + i] * Utils.parseInt(ss[i]);
                ++i;
            }
        } else {
            String[] subs = s.toLowerCase().split("\\s+");
            int i = 0;
            while (i < subs.length) {
                String sub = subs[i];
                if (sub.equals(GeneralWords.and.toString())) {
                    if (i == 0 || i == subs.length - 1) {
                        return null;
                    }
                } else {
                    float amount = 1.0f;
                    if (Noun.isIndefiniteArticle(sub)) {
                        if (i == subs.length - 1) {
                            return null;
                        }
                        amount = 1.0f;
                        sub = subs[++i];
                    } else if (sub.matches("^\\d+(.\\d+)?$")) {
                        if (i == subs.length - 1) {
                            return null;
                        }
                        amount = Float.parseFloat(sub);
                        sub = subs[++i];
                    }
                    if (CollectionUtils.contains(Language.getList("time.real"), sub)) {
                        if (i == subs.length - 1 || isMinecraftTimeSet && minecraftTime) {
                            return null;
                        }
                        sub = subs[++i];
                    } else if (CollectionUtils.contains(Language.getList("time.minecraft"), sub)) {
                        if (i == subs.length - 1 || isMinecraftTimeSet && !minecraftTime) {
                            return null;
                        }
                        minecraftTime = true;
                        sub = subs[++i];
                    }
                    if (minecraftTime) {
                        amount /= 72.0f;
                    }
                    if (sub.endsWith(",")) {
                        sub = sub.substring(0, sub.length() - 1);
                    }
                    Pair<String, Boolean> p = Utils.getEnglishPlural(sub);
                    sub = (String)p.first;
                    if (!parseValues.containsKey(sub)) {
                        return null;
                    }
                    if (sub.equals("tick") && minecraftTime) {
                        amount *= 72.0f;
                    }
                    t += Math.round(amount * (float)parseValues.get(sub).intValue());
                    isMinecraftTimeSet = true;
                }
                ++i;
            }
        }
        return new Timespan(t);
    }

    public Timespan(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("millis must be >= 0");
        }
        this.millis = millis;
    }

    public static Timespan fromTicks(int ticks) {
        return new Timespan(ticks * 50);
    }

    public long getMilliSeconds() {
        return this.millis;
    }

    public int getTicks() {
        return Math.round((float)this.millis / 50.0f);
    }

    public String toString() {
        return Timespan.toString(this.millis);
    }

    public String toString(int flags) {
        return Timespan.toString(this.millis, flags);
    }

    public static String toString(long millis) {
        return Timespan.toString(millis, 0);
    }

    public static String toString(long millis, int flags) {
        int i = 0;
        while (i < simpleValues.length - 1) {
            if (millis >= (long)((Integer)Timespan.simpleValues[i].second).intValue()) {
                if (millis % (long)((Integer)Timespan.simpleValues[i].second).intValue() != 0L) {
                    return String.valueOf(Timespan.toString(Math.floor(1.0 * (double)millis / (double)((Integer)Timespan.simpleValues[i].second).intValue()), simpleValues[i], flags)) + " " + GeneralWords.and + " " + Timespan.toString(1.0 * (double)(millis % (long)((Integer)Timespan.simpleValues[i].second).intValue()) / (double)((Integer)Timespan.simpleValues[i + 1].second).intValue(), simpleValues[i + 1], flags);
                }
                return Timespan.toString(1.0 * (double)millis / (double)((Integer)Timespan.simpleValues[i].second).intValue(), simpleValues[i], flags);
            }
            ++i;
        }
        return Timespan.toString(1.0 * (double)millis / (double)((Integer)Timespan.simpleValues[Timespan.simpleValues.length - 1].second).intValue(), simpleValues[simpleValues.length - 1], flags);
    }

    private static String toString(double amount, Pair<Noun, Integer> p, int flags) {
        return ((Noun)p.first).withAmount(amount, flags);
    }
}

