/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.Utils;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time
implements Serializable {
    private final int time;
    private static final Message m_error_24_hours = new Message("time.errors.24 hours");
    private static final Message m_error_12_hours = new Message("time.errors.12 hours");
    private static final Message m_error_60_minutes = new Message("time.errors.60 minutes");

    public Time(int time) {
        this.time = (time % 24000 + 24000) % 24000;
        assert (this.time >= 0 && this.time < 24000) : time;
    }

    public int getTicks() {
        return this.time;
    }

    public String toString() {
        return Time.toString(this.time);
    }

    public static String toString(int ticks) {
        assert (ticks >= 0 && ticks < 24000);
        int t = (ticks + 6000) % 24000;
        int hours = (int)Math.floor(t / 1000);
        int minutes = (int)Math.round((double)(t % 1000) / 16.666666667);
        if (minutes >= 60) {
            hours = (hours + 1) % 24;
            minutes -= 60;
        }
        return hours + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    public static final Time parse(String s) {
        if (s.matches("\\d?\\d:\\d\\d")) {
            int hours = Utils.parseInt(s.split(":")[0]);
            if (hours == 24) {
                hours = 0;
            } else if (hours > 24) {
                Skript.error("" + m_error_24_hours);
                return null;
            }
            int minutes = Utils.parseInt(s.split(":")[1]);
            if (minutes >= 60) {
                Skript.error("" + m_error_60_minutes);
                return null;
            }
            return new Time((int)Math.round((double)(hours * 1000 - 6000) + (double)minutes * 16.6666667));
        }
        Matcher m = Pattern.compile("(\\d?\\d)(:(\\d\\d))? ?(am|pm)", 2).matcher(s);
        if (m.matches()) {
            int hours = Utils.parseInt(m.group(1));
            if (hours == 12) {
                hours = 0;
            } else if (hours > 12) {
                Skript.error("" + m_error_12_hours);
                return null;
            }
            int minutes = 0;
            if (m.group(3) != null) {
                minutes = Utils.parseInt(m.group(3));
            }
            if (minutes >= 60) {
                Skript.error("" + m_error_60_minutes);
                return null;
            }
            if (m.group(4).equalsIgnoreCase("pm")) {
                hours += 12;
            }
            return new Time((int)Math.round((double)(hours * 1000 - 6000) + (double)minutes * 16.6666667));
        }
        return null;
    }

    public int hashCode() {
        return this.time;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Time)) {
            return false;
        }
        Time other = (Time)obj;
        return this.time == other.time;
    }
}

