/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Task
implements Runnable {
    private final JavaPlugin plugin;
    private final boolean async;
    private long period = -1L;
    private int taskID;

    public Task(JavaPlugin plugin, long delay, long period) {
        this(plugin, delay, period, false);
    }

    public Task(JavaPlugin plugin, long delay, long period, boolean async) {
        this.plugin = plugin;
        this.period = period;
        this.async = async;
        this.schedule(delay);
    }

    public Task(JavaPlugin plugin, long delay) {
        this(plugin, delay, false);
    }

    public Task(JavaPlugin plugin, long delay, boolean async) {
        this.plugin = plugin;
        this.async = async;
        this.schedule(delay);
    }

    private void schedule(long delay) {
        this.taskID = this.period == -1L ? (this.async ? (Skript.isRunningMinecraft(1, 4, 6) ? Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, (Runnable)this, delay).getTaskId() : Bukkit.getScheduler().scheduleAsyncDelayedTask((Plugin)this.plugin, (Runnable)this, delay)) : Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)this, delay)) : (this.async ? (Skript.isRunningMinecraft(1, 4, 6) ? Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this, delay, this.period).getTaskId() : Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)this.plugin, (Runnable)this, delay, this.period)) : Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)this, delay, this.period));
    }

    public final boolean isAlive() {
        return Bukkit.getScheduler().isQueued(this.taskID) || Bukkit.getScheduler().isCurrentlyRunning(this.taskID);
    }

    public final void cancel() {
        Bukkit.getScheduler().cancelTask(this.taskID);
    }

    public void setNextExecution(long delay) {
        assert (delay >= 0L);
        Bukkit.getScheduler().cancelTask(this.taskID);
        this.schedule(delay);
    }

    public void setPeriod(long period) {
        assert (period == -1L || period > 0L);
        if (period == this.period) {
            return;
        }
        this.period = period;
        if (this.isAlive()) {
            Bukkit.getScheduler().cancelTask(this.taskID);
            if (period != -1L) {
                this.schedule(period);
            }
        }
    }

    public static final <T> T callSync(Callable<T> c) {
        if (Bukkit.isPrimaryThread()) {
            try {
                return c.call();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        Future f = Bukkit.getScheduler().callSyncMethod((Plugin)Skript.getInstance(), c);
        try {
            while (true) {
                try {
                    return (T)f.get();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (ExecutionException e) {
            Skript.exception((Throwable)e, new String[0]);
        }
        catch (CancellationException cancellationException) {
        }
        catch (ThreadDeath threadDeath) {
            // empty catch block
        }
        return null;
    }
}

