/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.enchantments.Enchantment;

public class EnchantmentType {
    private final Enchantment type;
    private final int level;
    private static final Map<String, Enchantment> enchantmentNames = new HashMap<String, Enchantment>();
    private static final Pattern pattern;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                enchantmentNames.clear();
                Enchantment[] enchantmentArray = Enchantment.values();
                int n = enchantmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enchantment e = enchantmentArray[n2];
                    enchantmentNames.put(Language.get("enchantments.names." + e.getName()).toLowerCase(), e);
                    ++n2;
                }
            }
        });
        pattern = Pattern.compile(".+ \\d+");
    }

    public EnchantmentType(Enchantment type, int level) {
        assert (type != null);
        this.type = type;
        this.level = level;
    }

    public int getLevel() {
        return this.level == -1 ? 1 : this.level;
    }

    public int getInternalLevel() {
        return this.level;
    }

    public Enchantment getType() {
        return this.type;
    }

    public boolean has(ItemType item) {
        if (item.getEnchantments() == null) {
            return false;
        }
        Integer l = item.getEnchantments().get(this.type);
        if (l == null) {
            return false;
        }
        if (this.level == -1) {
            return true;
        }
        return l == this.level;
    }

    public String toString() {
        return String.valueOf(Language.get("enchantments.names." + this.type.getName())) + (this.level == -1 ? "" : " " + this.level);
    }

    public static String toString(Enchantment e) {
        return Language.get("enchantments.names." + e.getName());
    }

    public static String toString(Enchantment e, int flags) {
        return Language.get("enchantments.names." + e.getName());
    }

    public static EnchantmentType parse(String s) {
        if (pattern.matcher(s).matches()) {
            Enchantment ench = enchantmentNames.get(s.substring(0, s.lastIndexOf(32)).toLowerCase());
            if (ench == null) {
                return null;
            }
            return new EnchantmentType(ench, Utils.parseInt(s.substring(s.lastIndexOf(32) + 1)));
        }
        Enchantment ench = enchantmentNames.get(s.toLowerCase());
        if (ench == null) {
            return null;
        }
        return new EnchantmentType(ench, -1);
    }

    public static Enchantment parseEnchantment(String s) {
        return enchantmentNames.get(s.toLowerCase());
    }

    public static final Set<String> getNames() {
        return enchantmentNames.keySet();
    }
}

