/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.util.Checker;
import ch.njol.util.iterator.StoppableIterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class BlockLineIterator
extends StoppableIterator<Block> {
    public BlockLineIterator(final Block start, final Block end) throws IllegalStateException {
        super(new BlockIterator(start.getWorld(), start.getLocation().add(0.5, 0.5, 0.5).toVector(), end.equals(start) ? new Vector(1, 0, 0) : end.getLocation().subtract(start.getLocation()).toVector(), 0.0, 0), new Checker<Block>(){
            private final double overshotSq;
            {
                this.overshotSq = Math.pow(block.getLocation().distance(block2.getLocation()) + 2.0, 2.0);
            }

            @Override
            public boolean check(Block b) {
                if (b.getLocation().distanceSquared(start.getLocation()) > this.overshotSq) {
                    throw new IllegalStateException("BlockLineIterator missed the end block!");
                }
                return b.equals(end);
            }
        }, true);
    }

    public BlockLineIterator(final Location start, Vector dir, double dist) throws IllegalStateException {
        super(new BlockIterator(start.getWorld(), start.toVector(), dir, 0.0, 0), new Checker<Block>(dist){
            private final double distSq;
            {
                this.distSq = d * d;
            }

            @Override
            public boolean check(Block b) {
                return b.getLocation().add(0.5, 0.5, 0.5).distanceSquared(start) >= this.distSq;
            }
        }, false);
    }

    public BlockLineIterator(Block start, Vector dir, double dist) throws IllegalStateException {
        this(start.getLocation().add(0.5, 0.5, 0.5), dir, dist);
    }
}

