/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.block.Biome;

public abstract class BiomeUtils {
    private static final Map<String, Biome> parseMap = new HashMap<String, Biome>();
    private static final String[] names = new String[Biome.values().length];

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                parseMap.clear();
                Biome[] biomeArray = Biome.values();
                int n = biomeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Biome b = biomeArray[n2];
                    if (b != null) {
                        String[] ls = Language.getList("biomes." + b.name());
                        names[b.ordinal()] = ls[0];
                        String[] stringArray = ls;
                        int n3 = ls.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String l = stringArray[n4];
                            parseMap.put(l.toLowerCase(), b);
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    private BiomeUtils() {
    }

    public static final Biome parse(String s) {
        return parseMap.get(s.toLowerCase());
    }

    public static final String toString(Biome b) {
        return names[b.ordinal()];
    }

    public static final String getAllNames() {
        return StringUtils.join(names, ", ");
    }
}

