/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ChainedConverter;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.SerializableConverter;
import ch.njol.util.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Converters {
    private static List<Converter.ConverterInfo<?, ?>> converters = new ArrayList(50);
    private static final Map<Pair<Class<?>, Class<?>>, SerializableConverter<?, ?>> convertersQuickAccess = new HashMap();

    private Converters() {
    }

    public static List<Converter.ConverterInfo<?, ?>> getConverters() {
        return Collections.unmodifiableList(converters);
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, SerializableConverter<F, T> converter) {
        Converters.registerConverter(from, to, converter, 0);
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, SerializableConverter<F, T> converter, int options) {
        Skript.checkAcceptRegistrations();
        Converter.ConverterInfo<F, T> info = new Converter.ConverterInfo<F, T>(from, to, converter, options);
        int i = 0;
        while (i < converters.size()) {
            Converter.ConverterInfo<?, ?> info2 = converters.get(i);
            if (info2.from.isAssignableFrom(from) && to.isAssignableFrom(info2.to)) {
                converters.add(i, info);
                return;
            }
            ++i;
        }
        converters.add(info);
    }

    public static void createMissingConverters() {
        int i = 0;
        while (i < converters.size()) {
            Converter.ConverterInfo<?, ?> info = converters.get(i);
            int j = 0;
            while (j < converters.size()) {
                Converter.ConverterInfo<?, ?> info2 = converters.get(j);
                if ((info.options & 2) == 0 && (info2.options & 1) == 0 && info2.from.isAssignableFrom(info.to) && !Converters.converterExistsSlow(info.from, info2.to)) {
                    converters.add(Converters.createChainedConverter(info, info2));
                } else if ((info.options & 1) == 0 && (info2.options & 2) == 0 && info.from.isAssignableFrom(info2.to) && !Converters.converterExistsSlow(info2.from, info.to)) {
                    converters.add(Converters.createChainedConverter(info2, info));
                }
                ++j;
            }
            ++i;
        }
    }

    private static final boolean converterExistsSlow(Class<?> from, Class<?> to) {
        for (Converter.ConverterInfo<?, ?> i : converters) {
            if (!i.from.isAssignableFrom(from) && !from.isAssignableFrom(i.from) || !i.to.isAssignableFrom(to) && !to.isAssignableFrom(i.to)) continue;
            return true;
        }
        return false;
    }

    private static <F, M, T> Converter.ConverterInfo<F, T> createChainedConverter(Converter.ConverterInfo<?, ?> first, Converter.ConverterInfo<?, ?> second) {
        return new Converter.ConverterInfo(first.from, second.to, new ChainedConverter(first.converter, second.converter), first.options | second.options);
    }

    public static <F, T> T convert(F o, Class<T> to) {
        assert (to != null);
        if (o == null) {
            return null;
        }
        if (to.isInstance(o)) {
            return (T)o;
        }
        SerializableConverter<?, T> conv = Converters.getConverter(o.getClass(), to);
        if (conv == null) {
            return null;
        }
        return conv.convert(o);
    }

    public static final <F, T> T convert(F o, Class<? extends T>[] to) {
        Class<T> t;
        assert (to != null);
        if (o == null) {
            return null;
        }
        Class<? extends T>[] classArray = to;
        int n = to.length;
        int n2 = 0;
        while (n2 < n) {
            t = classArray[n2];
            if (t.isInstance(o)) {
                return (T)o;
            }
            ++n2;
        }
        classArray = to;
        n = to.length;
        n2 = 0;
        while (n2 < n) {
            t = classArray[n2];
            SerializableConverter<?, T> conv = Converters.getConverter(o.getClass(), t);
            if (conv != null) {
                return conv.convert(o);
            }
            ++n2;
        }
        return null;
    }

    public static <T> T[] convertArray(Object[] o, Class<T> to) {
        assert (to != null);
        if (o == null) {
            return null;
        }
        if (to.isAssignableFrom(o.getClass().getComponentType())) {
            return o;
        }
        ArrayList<T> l = new ArrayList<T>(o.length);
        Object[] objectArray = o;
        int n = o.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            T c = Converters.convert(e, to);
            if (c != null) {
                l.add(c);
            }
            ++n2;
        }
        return l.toArray((Object[])Array.newInstance(to, l.size()));
    }

    public static <T> T[] convertArray(Object[] o, Class<? extends T>[] to, Class<T> superType) {
        assert (to != null);
        if (o == null) {
            return null;
        }
        Class<? extends T>[] classArray = to;
        int n = to.length;
        int n2 = 0;
        while (n2 < n) {
            Class<T> t = classArray[n2];
            if (t.isAssignableFrom(o.getClass().getComponentType())) {
                return o;
            }
            ++n2;
        }
        ArrayList<T> l = new ArrayList<T>(o.length);
        Object[] objectArray = o;
        int n3 = o.length;
        n = 0;
        while (n < n3) {
            Object e = objectArray[n];
            T c = Converters.convert(e, to);
            if (c != null) {
                l.add(c);
            }
            ++n;
        }
        return l.toArray((Object[])Array.newInstance(superType, l.size()));
    }

    public static final boolean converterExists(Class<?> from, Class<?> to) {
        assert (from != null && to != null);
        if (to.isAssignableFrom(from) || from.isAssignableFrom(to)) {
            return true;
        }
        return Converters.getConverter(from, to) != null;
    }

    public static final <F, T> SerializableConverter<? super F, ? extends T> getConverter(Class<F> from, Class<T> to) {
        assert (from != null && to != null);
        Pair<Class<F>, Class<T>> p = new Pair<Class<F>, Class<T>>(from, to);
        if (convertersQuickAccess.containsKey(p)) {
            return convertersQuickAccess.get(p);
        }
        SerializableConverter<F, T> c = Converters.getConverter_i(from, to);
        convertersQuickAccess.put(p, c);
        return c;
    }

    private static final <F, T> SerializableConverter<? super F, ? extends T> getConverter_i(Class<F> from, Class<T> to) {
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!conv.from.isAssignableFrom(from) || !to.isAssignableFrom(conv.to)) continue;
            return conv.converter;
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (conv.from.isAssignableFrom(from) && conv.to.isAssignableFrom(to)) {
                return Converter.ConverterUtils.createInstanceofConverter(conv.converter, to);
            }
            if (!from.isAssignableFrom(conv.from) || !to.isAssignableFrom(conv.to)) continue;
            return Converter.ConverterUtils.createInstanceofConverter(conv);
        }
        for (Converter.ConverterInfo<?, ?> conv : converters) {
            if (!from.isAssignableFrom(conv.from) || !conv.to.isAssignableFrom(to)) continue;
            return Converter.ConverterUtils.createDoubleInstanceofConverter(conv, to);
        }
        return null;
    }

    public static final <F, T> T[] convertUnsafe(F[] from, Class<?> to, Converter<? super F, ? extends T> conv) {
        return Converters.convert(from, to, conv);
    }

    public static final <F, T> T[] convert(F[] from, Class<T> to, Converter<? super F, ? extends T> conv) {
        assert (from != null);
        assert (to != null);
        assert (conv != null);
        Object[] ts = (Object[])Array.newInstance(to, from.length);
        int j = 0;
        int i = 0;
        while (i < from.length) {
            Object t;
            Object v0 = t = from[i] == null ? null : conv.convert((F)from[i]);
            if (t != null) {
                ts[j++] = t;
            }
            ++i;
        }
        if (j != ts.length) {
            return Arrays.copyOf(ts, j);
        }
        return ts;
    }
}

