/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.StringMode;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.ArrayIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public abstract class Classes {
    private static ClassInfo<?>[] classInfos = null;
    private static final List<ClassInfo<?>> tempClassInfos = new ArrayList();
    private static final HashMap<Class<?>, ClassInfo<?>> exactClassInfos = new HashMap();
    private static final HashMap<Class<?>, ClassInfo<?>> superClassInfos = new HashMap();
    private static final HashMap<String, ClassInfo<?>> classInfosByCodeName = new HashMap();

    private Classes() {
    }

    public static <T> void registerClass(ClassInfo<T> info) {
        Skript.checkAcceptRegistrations();
        if (classInfosByCodeName.containsKey(info.getCodeName())) {
            throw new IllegalArgumentException("Can't register " + info.getC().getName() + " with the code name " + info.getCodeName() + " because that name is already used by " + classInfosByCodeName.get(info.getCodeName()));
        }
        if (exactClassInfos.containsKey(info.getC())) {
            throw new IllegalArgumentException("Can't register the class info " + info.getCodeName() + " because the class " + info.getC().getName() + " is already registered");
        }
        exactClassInfos.put(info.getC(), info);
        classInfosByCodeName.put(info.getCodeName(), info);
        tempClassInfos.add(info);
    }

    public static final void onRegistrationsStop() {
        Classes.sortClassInfos();
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> ci = classInfoArray[n2];
            if (ci.getSerializeAs() != null) {
                ClassInfo<?> sa = Classes.getExactClassInfo(ci.getSerializeAs());
                if (sa == null) {
                    Skript.error(String.valueOf(ci.getCodeName()) + "'s 'serializeAs' class is not registered");
                } else if (sa.getSerializer() == null) {
                    Skript.error(String.valueOf(ci.getCodeName()) + "'s 'serializeAs' class is not serializable");
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void sortClassInfos() {
        assert (classInfos == null);
        LinkedList classInfos = new LinkedList();
        block0: for (ClassInfo<?> ci : tempClassInfos) {
            if (ci.after() == null || ci.after().isEmpty()) continue;
            for (ClassInfo<?> ci2 : tempClassInfos) {
                if (!ci.after().contains(ci2.getCodeName())) continue;
                ci2.before().add(ci.getCodeName());
                ci.after().remove(ci2.getCodeName());
                if (ci.after().isEmpty()) continue block0;
            }
        }
        for (ClassInfo<?> ci : tempClassInfos) {
            for (ClassInfo<?> ci2 : tempClassInfos) {
                if (ci == ci2 || !ci2.getC().isAssignableFrom(ci.getC())) continue;
                ci.before().add(ci2.getCodeName());
            }
        }
        boolean changed = true;
        while (changed) {
            void var2_4;
            changed = false;
            boolean bl = false;
            while (var2_4 < tempClassInfos.size()) {
                ClassInfo<?> ci = tempClassInfos.get((int)var2_4);
                if (ci.before().isEmpty()) {
                    classInfos.addFirst(ci);
                    tempClassInfos.remove((int)var2_4);
                    --var2_4;
                    for (ClassInfo<?> ci2 : tempClassInfos) {
                        ci2.before().remove(ci.getCodeName());
                    }
                    changed = true;
                }
                ++var2_4;
            }
        }
        Classes.classInfos = classInfos.toArray(new ClassInfo[classInfos.size()]);
        if (!tempClassInfos.isEmpty()) {
            throw new IllegalStateException("ClassInfos with circular dependencies detected: " + StringUtils.join(tempClassInfos, ", "));
        }
        if (Skript.testing()) {
            for (ClassInfo classInfo : classInfos) {
                if ((classInfo.before() == null || classInfo.before().isEmpty()) && (classInfo.after() == null || classInfo.after().isEmpty())) continue;
                HashSet<String> s = new HashSet<String>();
                if (classInfo.before() != null) {
                    s.addAll(classInfo.before());
                }
                if (classInfo.after() != null) {
                    s.addAll(classInfo.after());
                }
                Skript.info(String.valueOf(s.size()) + " dependency/ies could not be resolved for " + classInfo + ": " + s);
            }
        }
    }

    private static final void checkAllowClassInfoInteraction() {
        if (Skript.acceptRegistrations) {
            throw new IllegalStateException("Cannot use classinfos until registration is over");
        }
    }

    public static Iterable<ClassInfo<?>> getClassInfos() {
        Classes.checkAllowClassInfoInteraction();
        return new Iterable<ClassInfo<?>>(){

            @Override
            public Iterator<ClassInfo<?>> iterator() {
                return new ArrayIterator(classInfos);
            }
        };
    }

    public static ClassInfo<?> getClassInfo(String codeName) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = classInfosByCodeName.get(codeName);
        if (ci == null) {
            throw new SkriptAPIException("No class info found for " + codeName);
        }
        return ci;
    }

    public static ClassInfo<?> getClassInfoNoError(String codeName) {
        Classes.checkAllowClassInfoInteraction();
        return classInfosByCodeName.get(codeName);
    }

    public static <T> ClassInfo<T> getExactClassInfo(Class<T> c) {
        return exactClassInfos.get(c);
    }

    public static <T> ClassInfo<? super T> getSuperClassInfo(Class<T> c) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> i = superClassInfos.get(c);
        if (i != null) {
            return i;
        }
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> ci = classInfoArray[n2];
            if (ci.getC().isAssignableFrom(c)) {
                if (!Skript.acceptRegistrations) {
                    superClassInfos.put(c, ci);
                }
                return ci;
            }
            ++n2;
        }
        return null;
    }

    public static Class<?> getClass(String codeName) {
        Classes.checkAllowClassInfoInteraction();
        return Classes.getClassInfo(codeName).getC();
    }

    public static ClassInfo<?> getClassInfoFromUserInput(String name) {
        Classes.checkAllowClassInfoInteraction();
        name = name.toLowerCase();
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ClassInfo<?> ci = classInfoArray[n2];
            if (ci.getUserInputPatterns() != null) {
                Pattern[] patternArray = ci.getUserInputPatterns();
                int n3 = patternArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Pattern pattern = patternArray[n4];
                    if (pattern.matcher(name).matches()) {
                        return ci;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Class<?> getClassFromUserInput(String name) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = Classes.getClassInfoFromUserInput(name);
        return ci == null ? null : ci.getC();
    }

    public static DefaultExpression<?> getDefaultExpression(String codeName) {
        Classes.checkAllowClassInfoInteraction();
        return Classes.getClassInfo(codeName).getDefaultExpression();
    }

    public static <T> DefaultExpression<T> getDefaultExpression(Class<T> c) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getDefaultExpression();
    }

    public static final String getExactClassName(Class<?> c) {
        Classes.checkAllowClassInfoInteraction();
        ClassInfo<?> ci = exactClassInfos.get(c);
        return ci == null ? null : ci.getCodeName();
    }

    public static <T> T parseSimple(String s, Class<T> c, ParseContext context) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            ClassInfo<?>[] classInfoArray = classInfos;
            int n = classInfos.length;
            int n2 = 0;
            while (n2 < n) {
                ClassInfo<?> info = classInfoArray[n2];
                if (info.getParser() != null && info.getParser().canParse(context) && c.isAssignableFrom(info.getC())) {
                    log.clear();
                    Object t = info.getParser().parse(s, context);
                    if (t != null) {
                        log.printLog();
                        Object obj = t;
                        return (T)obj;
                    }
                }
                ++n2;
            }
            log.printError();
        }
        finally {
            log.stop();
        }
        return null;
    }

    public static <T> T parse(String s, Class<T> c, ParseContext context) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T t = Classes.parseSimple(s, c, context);
            if (t != null) {
                log.printLog();
                T t2 = t;
                return t2;
            }
            for (Converter.ConverterInfo<?, ?> conv : Converters.getConverters()) {
                if (!c.isAssignableFrom(conv.to)) continue;
                log.clear();
                Object o = Classes.parseSimple(s, conv.from, context);
                if (o == null || (t = conv.converter.convert(o)) == null) continue;
                log.printLog();
                T t3 = t;
                return t3;
            }
            log.printError();
        }
        finally {
            log.stop();
        }
        return null;
    }

    public static final <T> Parser<? extends T> getParser(Class<T> to) {
        Classes.checkAllowClassInfoInteraction();
        int i = classInfos.length - 1;
        while (i >= 0) {
            ClassInfo<?> ci = classInfos[i];
            if (to.isAssignableFrom(ci.getC()) && ci.getParser() != null) {
                return ci.getParser();
            }
            --i;
        }
        for (Converter.ConverterInfo<?, ?> conv : Converters.getConverters()) {
            if (!to.isAssignableFrom(conv.to)) continue;
            int i2 = classInfos.length - 1;
            while (i2 >= 0) {
                ClassInfo<?> ci = classInfos[i2];
                if (conv.from.isAssignableFrom(ci.getC()) && ci.getParser() != null) {
                    return Classes.createConvertedParser(ci.getParser(), conv.converter);
                }
                --i2;
            }
        }
        return null;
    }

    public static final <T> Parser<? extends T> getExactParser(Class<T> c) {
        if (Skript.acceptRegistrations) {
            for (ClassInfo<?> ci : tempClassInfos) {
                if (ci.getC() != c) continue;
                return ci.getParser();
            }
            return null;
        }
        ClassInfo<T> ci = Classes.getExactClassInfo(c);
        return ci == null ? null : ci.getParser();
    }

    private static final <F, T> Parser<T> createConvertedParser(final Parser<?> parser, final Converter<F, T> converter) {
        return new Parser<T>(){

            @Override
            public T parse(String s, ParseContext context) {
                Object f = parser.parse(s, context);
                if (f == null) {
                    return null;
                }
                return converter.convert(f);
            }

            @Override
            public String toString(T o, int flags) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String toVariableNameString(T o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getVariableNamePattern() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String toString(Object o) {
        return Classes.toString(o, StringMode.MESSAGE, 0);
    }

    public static String getDebugMessage(Object o) {
        return Classes.toString(o, StringMode.DEBUG, 0);
    }

    public static final <T> String toString(T o, StringMode mode) {
        return Classes.toString(o, mode, 0);
    }

    private static final <T> String toString(T o, StringMode mode, int flags) {
        assert (flags == 0 || mode == StringMode.MESSAGE);
        if (o == null) {
            return "<none>";
        }
        if (o.getClass().isArray()) {
            if (((Object[])o).length == 0) {
                return "<none>";
            }
            StringBuilder b = new StringBuilder();
            boolean first = true;
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                if (!first) {
                    b.append(", ");
                }
                b.append(Classes.toString(i, mode, flags));
                first = false;
                ++n2;
            }
            return "[" + b.toString() + "]";
        }
        ClassInfo<?>[] classInfoArray = classInfos;
        int n = classInfos.length;
        int n3 = 0;
        while (n3 < n) {
            ClassInfo<?> ci = classInfoArray[n3];
            if (ci.getParser() != null && ci.getC().isInstance(o)) {
                String s;
                String string = mode == StringMode.MESSAGE ? ci.getParser().toString(o, flags) : (s = mode == StringMode.DEBUG ? "[" + ci.getCodeName() + ":" + ci.getParser().toString(o, mode) + "]" : ci.getParser().toString(o, mode));
                if (s != null) {
                    return s;
                }
            }
            ++n3;
        }
        return mode == StringMode.VARIABLE_NAME ? "object:" + o : "" + o;
    }

    public static final String toString(Object[] os, int flags) {
        return Classes.toString(os, true, StringMode.MESSAGE, flags);
    }

    public static final String toString(Object[] os, boolean and) {
        return Classes.toString(os, and, StringMode.MESSAGE, 0);
    }

    public static final String toString(Object[] os, boolean and, StringMode mode) {
        return Classes.toString(os, and, mode, 0);
    }

    private static final String toString(Object[] os, boolean and, StringMode mode, int flags) {
        if (os.length == 0) {
            return Classes.toString(null);
        }
        if (os.length == 1) {
            return Classes.toString(os[0], mode, flags);
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < os.length) {
            if (i != 0) {
                if (i == os.length - 1) {
                    b.append(and ? " and " : " or ");
                } else {
                    b.append(", ");
                }
            }
            b.append(Classes.toString(os[i], mode, flags));
            ++i;
        }
        return b.toString();
    }

    public static final Pair<String, String> serialize(Object o) {
        ClassInfo<?> ci = Classes.getSuperClassInfo(o.getClass());
        if (ci == null) {
            return null;
        }
        if (ci.getSerializeAs() != null) {
            ClassInfo<?> as = Classes.getExactClassInfo(ci.getSerializeAs());
            if (as == null || as.getSerializer() == null) {
                throw new SkriptAPIException(String.valueOf(ci.getSerializeAs().getName()) + ", the class to serialize " + o.getClass().getName() + " as, is not registered or not serializable");
            }
            Object s = Converters.convert(o, as.getC());
            if (s == null) {
                return null;
            }
            return new Pair<String, String>(as.getCodeName(), as.getSerializer().serialize(s));
        }
        if (ci.getSerializer() != null) {
            return new Pair<String, String>(ci.getCodeName(), ci.getSerializer().serialize(o));
        }
        return null;
    }

    public static final Object deserialize(String type, String value) {
        assert (Bukkit.isPrimaryThread());
        ClassInfo<?> ci = Classes.getClassInfo(type);
        if (ci == null || ci.getSerializer() == null) {
            return null;
        }
        return ci.getSerializer().deserialize(value);
    }
}

