/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.config.Node;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.Verbosity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.Bukkit;

public abstract class SkriptLogger {
    private static Node node = null;
    private static Verbosity verbosity = Verbosity.NORMAL;
    static boolean debug;
    public static final Level DEBUG;
    public static final Logger LOGGER;
    private static final HandlerList handlers;
    private static final Collection<Filter> filters;

    static {
        DEBUG = new Level("DEBUG", Level.INFO.intValue()){
            private static final long serialVersionUID = 8959282461654206205L;
        };
        LOGGER = Bukkit.getServer() != null ? Bukkit.getLogger() : Logger.getLogger("global");
        handlers = new HandlerList();
        filters = new ArrayList<Filter>();
        final Filter oldFilter = LOGGER.getFilter();
        LOGGER.setFilter(new Filter(){

            @Override
            public boolean isLoggable(LogRecord record) {
                if (oldFilter != null && !oldFilter.isLoggable(record)) {
                    return false;
                }
                for (Filter f : filters) {
                    if (f.isLoggable(record)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public static final RetainingLogHandler startRetainingLog() {
        return SkriptLogger.startLogHandler(new RetainingLogHandler());
    }

    public static final ParseLogHandler startParseLogHandler() {
        return SkriptLogger.startLogHandler(new ParseLogHandler());
    }

    public static final <T extends LogHandler> T startLogHandler(T h) {
        handlers.add(h);
        return h;
    }

    static final void removeHandler(LogHandler h) {
        if (!handlers.contains(h)) {
            return;
        }
        if (handlers.remove() != h) {
            int i = 1;
            while (handlers.remove() != h) {
                ++i;
            }
            LOGGER.severe("[Skript] " + i + " log handler" + (i == 1 ? " was" : "s were") + " not stopped properly! (at " + SkriptLogger.getCaller() + ") [if you're a server admin and you see this message please file a bug report at http://dev.bukkit.org/server-mods/skript/tickets/ if there is not already one]");
        }
    }

    static final boolean isStopped(LogHandler h) {
        return !handlers.contains(h);
    }

    static final StackTraceElement getCaller() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            if (!e.getClassName().startsWith(SkriptLogger.class.getPackage().getName())) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static void setVerbosity(Verbosity v) {
        verbosity = v;
        if (v.compareTo(Verbosity.DEBUG) >= 0) {
            debug = true;
        }
    }

    public static void setNode(Node node) {
        SkriptLogger.node = node == null || node.getParent() == null ? null : node;
    }

    public static Node getNode() {
        return node;
    }

    public static void log(Level level, String message) {
        SkriptLogger.log(new LogEntry(level, message, node));
    }

    public static void log(LogEntry entry) {
        if (entry == null) {
            return;
        }
        for (LogHandler h : handlers) {
            if (h.log(entry)) continue;
            return;
        }
        LOGGER.log(entry.getLevel(), "[Skript] " + entry.getMessage());
    }

    public static void logAll(Collection<LogEntry> entries) {
        block0: for (LogEntry entry : entries) {
            assert (entry != null);
            for (LogHandler h : handlers) {
                if (!h.log(entry)) continue block0;
            }
            LOGGER.log(entry.getLevel(), "[Skript] " + entry.getMessage());
        }
    }

    public static boolean log(Verbosity minVerb) {
        return minVerb.compareTo(verbosity) <= 0;
    }

    public static boolean debug() {
        return debug;
    }

    public static final void addFilter(Filter f) {
        filters.add(f);
    }

    public static final boolean removeFilter(Filter f) {
        return filters.remove(f);
    }
}

