/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ParseLogHandler
extends LogHandler {
    private LogEntry error = null;
    private final List<LogEntry> log = new ArrayList<LogEntry>();
    boolean printedErrorOrLog = false;

    @Override
    public boolean log(LogEntry entry) {
        if (entry.getLevel() == Level.SEVERE) {
            if (this.error == null || entry.getQuality() > this.error.getQuality()) {
                this.error = entry;
            }
        } else {
            this.log.add(entry);
        }
        return false;
    }

    @Override
    public void onStop() {
        if (!this.printedErrorOrLog && Skript.testing()) {
            System.out.println("Parse log wasn't instructed to print anything at " + SkriptLogger.getCaller());
        }
    }

    public void error(String error, ErrorQuality quality) {
        this.log(new LogEntry(Level.SEVERE, quality, error));
    }

    public void clear() {
        this.log.clear();
    }

    public void printLog() {
        this.printedErrorOrLog = true;
        this.stop();
        SkriptLogger.logAll(this.log);
    }

    public void printError() {
        this.printError(null);
    }

    public void printError(String def) {
        this.printedErrorOrLog = true;
        this.stop();
        if (this.error != null) {
            SkriptLogger.log(this.error);
        } else if (def != null) {
            SkriptLogger.log(new LogEntry(Level.SEVERE, def));
        }
    }

    public int getNumErrors() {
        return this.error == null ? 0 : 1;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public LogEntry getError() {
        return this.error;
    }
}

