/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Node;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.SkriptLogger;
import java.util.logging.Level;

public class LogEntry {
    public final Level level;
    public int quality;
    public String message;
    private final Node node;
    private final String from;
    private static final String skriptLogPackageName = SkriptLogger.class.getPackage().getName();

    public LogEntry(Level level, String message) {
        this(level, ErrorQuality.SEMANTIC_ERROR.quality(), message, SkriptLogger.getNode());
    }

    public LogEntry(Level level, int quality, String message) {
        this(level, quality, message, SkriptLogger.getNode());
    }

    public LogEntry(Level level, ErrorQuality quality, String message) {
        this(level, quality.quality(), message, SkriptLogger.getNode());
    }

    public LogEntry(Level level, String message, Node node) {
        this(level, ErrorQuality.SEMANTIC_ERROR.quality(), message, node);
    }

    public LogEntry(Level level, ErrorQuality quality, String message, Node node) {
        this(level, quality.quality(), message, node);
    }

    public LogEntry(Level level, int quality, String message, Node node) {
        this.level = level;
        this.quality = quality;
        this.message = message;
        this.node = node;
        this.from = Skript.debug() ? LogEntry.findCaller() : "";
    }

    static String findCaller() {
        StackTraceElement[] es = new Exception().getStackTrace();
        int i = 0;
        while (i < es.length) {
            if (es[i].getClassName().startsWith(skriptLogPackageName)) {
                ++i;
                while (i < es.length - 1 && (es[i].getClassName().startsWith(skriptLogPackageName) || es[i].getClassName().equals(Skript.class.getName()))) {
                    ++i;
                }
                return " (from " + es[i] + ")";
            }
            ++i;
        }
        return es.length == 0 ? " (from an unknown source)" : " (from " + es[es.length - 1] + ")";
    }

    public Level getLevel() {
        return this.level;
    }

    public int getQuality() {
        return this.quality;
    }

    public String getMessage() {
        return this.toString();
    }

    public String toString() {
        if (this.node == null || this.level.intValue() < Level.WARNING.intValue()) {
            return this.message;
        }
        return String.valueOf(this.message) + this.from + " (" + this.node.getConfig().getFileName() + ", line " + this.node.getLine() + (this.node.getOrig() == null ? "" : ": '" + this.node.getOrig().trim() + "')");
    }
}

