/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import java.util.logging.Level;

public class ErrorDescLogHandler
extends LogHandler {
    private final String before;
    private final String after;
    private final String success;
    private boolean hadError = false;

    public ErrorDescLogHandler() {
        this(null, null, null);
    }

    public ErrorDescLogHandler(String before, String after, String success) {
        this.before = before;
        this.after = after;
        this.success = success;
    }

    @Override
    public boolean log(LogEntry entry) {
        if (!this.hadError && entry.getLevel() == Level.SEVERE) {
            this.hadError = true;
            this.beforeErrors();
        }
        return true;
    }

    protected void beforeErrors() {
        if (this.before != null) {
            Skript.error(this.before);
        }
    }

    protected void afterErrors() {
        if (this.after != null) {
            Skript.error(this.after);
        }
    }

    protected void onSuccess() {
        if (this.success != null) {
            Skript.info(this.success);
        }
    }

    @Override
    public void onStop() {
        if (!this.hadError) {
            this.onSuccess();
        } else {
            this.afterErrors();
        }
    }
}

