/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Message;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexMessage
extends Message {
    private final String prefix;
    private final String suffix;
    private final int flags;
    private Pattern pattern = null;

    public RegexMessage(String key, String prefix, String suffix, int flags) {
        super(key);
        this.prefix = prefix == null ? "" : prefix;
        this.suffix = suffix == null ? "" : suffix;
        this.flags = flags;
    }

    public RegexMessage(String key, String prefix, String suffix) {
        this(key, prefix, suffix, 0);
    }

    public RegexMessage(String key) {
        this(key, "", "", 0);
    }

    public RegexMessage(String key, int flags) {
        this(key, "", "", flags);
    }

    public Pattern getPattern() {
        this.validate();
        return this.pattern;
    }

    @Override
    public String toString() {
        return String.valueOf(this.prefix) + this.getValue() + this.suffix;
    }

    @Override
    protected void onValueChange() {
        try {
            this.pattern = Pattern.compile(String.valueOf(this.prefix) + this.getValue() + this.suffix, this.flags);
        }
        catch (PatternSyntaxException e) {
            Skript.error("Invalid Regex pattern '" + this.getValue() + "' found in language entry '" + this.key + "': " + e.getLocalizedMessage());
        }
    }
}

