/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Message;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Noun
extends Message {
    public static final String GENDERS_SECTION = "genders.";
    public static final int PLURAL = -2;
    public static final int NO_GENDER = -3;
    public static final String PLURAL_TOKEN = "x";
    public static final String NO_GENDER_TOKEN = "-";
    private String singular;
    private String plural;
    private int gender = 0;
    private static final HashMap<String, Integer> genders = new HashMap();
    private static final List<String> indefiniteArticles = new ArrayList<String>(3);
    private static final List<String> definiteArticles = new ArrayList<String>(3);
    private static String definitePluralArticle = "";

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                String dpa;
                HashMap<String, String> lang = Language.useLocal ? Language.localized : Language.english;
                genders.clear();
                indefiniteArticles.clear();
                definiteArticles.clear();
                int i = 0;
                while (i < 100) {
                    String g = (String)lang.get(Noun.GENDERS_SECTION + i + ".id");
                    if (g == null) break;
                    if (g.equalsIgnoreCase(Noun.PLURAL_TOKEN) || g.equalsIgnoreCase(Noun.NO_GENDER_TOKEN)) {
                        Skript.error("gender #" + i + " uses a reserved character as ID, please use something different!");
                    } else {
                        genders.put(g, i);
                        String ia = (String)lang.get(Noun.GENDERS_SECTION + i + ".indefinite article");
                        indefiniteArticles.add(ia == null ? "" : ia);
                        String da = (String)lang.get(Noun.GENDERS_SECTION + i + ".definite article");
                        definiteArticles.add(da == null ? "" : da);
                    }
                    ++i;
                }
                if (genders.isEmpty()) {
                    Skript.error("No genders defined in language file " + Language.getName() + ".lang!");
                    indefiniteArticles.add("");
                    definiteArticles.add("");
                }
                if ((dpa = (String)lang.get("genders.plural.definite article")) == null) {
                    Skript.error("Missing entry 'genders.plural.definite article' in the " + Language.getName() + " language file!");
                }
                definitePluralArticle = dpa == null ? "" : dpa;
            }
        }, Language.LanguageListenerPriority.EARLIEST);
    }

    public Noun(String key) {
        super(key);
    }

    @Override
    protected void onValueChange() {
        String value = this.getValue();
        if (value == null) {
            this.plural = this.singular = this.key;
            this.gender = 0;
            return;
        }
        int g = value.lastIndexOf(64);
        if (g != -1) {
            this.gender = Noun.getGender(value.substring(g + 1).trim(), this.key);
            value = value.substring(0, g).trim();
        } else {
            this.gender = 0;
        }
        Pair<String, String> p = Noun.getPlural(value);
        this.singular = (String)p.first;
        this.plural = (String)p.second;
        if (this.gender == -2 && !this.singular.equals(this.plural)) {
            Skript.warning("Noun '" + this.key + "' is of gender 'plural', but has different singular and plural values.");
        }
    }

    @Override
    public String toString() {
        this.validate();
        return this.singular;
    }

    public String toString(boolean plural) {
        this.validate();
        return plural ? this.plural : this.singular;
    }

    public String withIndefiniteArticle() {
        return this.toString(4);
    }

    public String getIndefiniteArticle() {
        this.validate();
        return this.gender == -2 || this.gender == -3 ? "" : indefiniteArticles.get(this.gender);
    }

    public String withDefiniteArticle() {
        return this.toString(2);
    }

    public String withDefiniteArticle(boolean plural) {
        return this.toString(2 | (plural ? 1 : 0));
    }

    public String getDefiniteArticle() {
        this.validate();
        return this.gender == -2 ? definitePluralArticle : (this.gender == -3 ? "" : definiteArticles.get(this.gender));
    }

    public String toString(int flags) {
        this.validate();
        StringBuilder b = new StringBuilder();
        if (this.gender == -2) {
            if ((flags & 2) != 0) {
                b.append(definitePluralArticle).append(" ");
            }
        } else if (this.gender != -3) {
            if ((flags & 2) != 0) {
                b.append(definiteArticles.get(this.gender)).append(" ");
            } else if ((flags & 4) != 0) {
                b.append(indefiniteArticles.get(this.gender)).append(" ");
            }
        }
        b.append((flags & 1) != 0 ? this.plural : this.singular);
        return b.toString();
    }

    public String withAmount(double amount) {
        this.validate();
        return String.valueOf(Skript.toString(amount)) + " " + (amount == 1.0 ? this.singular : this.plural);
    }

    public String withAmount(double amount, int flags) {
        this.validate();
        if (amount == 1.0) {
            if (this.gender == -3) {
                return this.toString((flags & 1) != 0);
            }
            if (this.gender == -2) {
                if ((flags & 2) != 0) {
                    return String.valueOf(definitePluralArticle) + " " + this.plural;
                }
                return this.plural;
            }
            if ((flags & 2) != 0) {
                return (flags & 1) != 0 ? String.valueOf(definitePluralArticle) + " " + this.plural : String.valueOf(definiteArticles.get(this.gender)) + " " + this.singular;
            }
            if ((flags & 4) != 0) {
                return String.valueOf(indefiniteArticles.get(this.gender)) + " " + this.singular;
            }
            if ((flags & 1) != 0) {
                return this.plural;
            }
        }
        return String.valueOf(Skript.toString(amount)) + " " + (amount == 1.0 ? this.singular : this.plural);
    }

    public String getSingular() {
        this.validate();
        return this.singular;
    }

    public String getPlural() {
        this.validate();
        return this.plural;
    }

    public static Pair<String, String> getPlural(String s) {
        String x;
        Pair<String, String> r = new Pair<String, String>("", "");
        int part = 3;
        int i = StringUtils.count(s, '\u00a6');
        int last = 0;
        int c = -1;
        while ((c = s.indexOf(166, c + 1)) != -1) {
            x = s.substring(last, c);
            if ((part & 1) != 0) {
                r.first = String.valueOf(r.first) + x;
            }
            if ((part & 2) != 0) {
                r.second = String.valueOf(r.second) + x;
            }
            part = i >= 2 ? part % 3 + 1 : (part == 2 ? 3 : 2);
            last = c + 1;
            --i;
        }
        x = s.substring(last);
        if ((part & 1) != 0) {
            r.first = String.valueOf(r.first) + x;
        }
        if ((part & 2) != 0) {
            r.second = String.valueOf(r.second) + x;
        }
        return r;
    }

    public static String normalizePluralMarkers(String s) {
        int c = StringUtils.count(s, '\u00a6');
        if (c % 3 == 0) {
            return s;
        }
        if (c % 3 == 2) {
            int g = s.lastIndexOf(64);
            if (g == -1) {
                return String.valueOf(s) + "\u00a6";
            }
            return String.valueOf(s.substring(0, g)) + "\u00a6" + s.substring(g);
        }
        int x = s.lastIndexOf(166);
        int g = s.lastIndexOf(64);
        if (g == -1) {
            return String.valueOf(s.substring(0, x)) + "\u00a6" + s.substring(x) + "\u00a6";
        }
        return String.valueOf(s.substring(0, x)) + "\u00a6" + s.substring(x, g) + "\u00a6" + s.substring(g);
    }

    private static int getGender(String gender, String key) {
        if (gender.equalsIgnoreCase(PLURAL_TOKEN)) {
            return -2;
        }
        if (gender.equalsIgnoreCase(NO_GENDER_TOKEN)) {
            return -3;
        }
        Integer i = genders.get(gender);
        if (i != null) {
            return i;
        }
        Skript.warning("Undefined gender '" + gender + "' at " + key);
        return 0;
    }

    public static final String getGenderID(int gender) {
        if (gender == -2) {
            return PLURAL_TOKEN;
        }
        if (gender == -3) {
            return NO_GENDER_TOKEN;
        }
        return (Language.useLocal && Language.localized != null ? Language.localized : Language.english).get(GENDERS_SECTION + gender + ".id");
    }

    public static final Pair<String, Integer> stripGender(String s, String key) {
        int c = s.lastIndexOf(64);
        int g = -1;
        if (c != -1) {
            g = Noun.getGender(s.substring(c + 1).trim(), key);
            s = s.substring(0, c).trim();
        }
        return new Pair<String, Integer>(s, g);
    }

    public static final String stripIndefiniteArticle(String s) {
        for (String a : indefiniteArticles) {
            if (!StringUtils.startsWithIgnoreCase(s, String.valueOf(a) + " ")) continue;
            return s.substring(a.length() + 1);
        }
        return s;
    }

    public static final boolean isIndefiniteArticle(String s) {
        return indefiniteArticles.contains(s.toLowerCase());
    }

    public static final boolean isDefiniteArticle(String s) {
        return definiteArticles.contains(s.toLowerCase());
    }

    public static final String toString(String singular, String plural, int gender, int flags) {
        if (gender == -3) {
            return (flags & 1) != 0 ? plural : singular;
        }
        if (gender == -2) {
            return (flags & 2) != 0 ? String.valueOf(definitePluralArticle) + " " + plural : plural;
        }
        if (gender < 0 || gender >= indefiniteArticles.size()) {
            gender = 0;
        }
        return String.valueOf((flags & 4) != 0 ? indefiniteArticles.get(gender) : ((flags & 2) != 0 ? definiteArticles.get(gender) : "")) + ((flags & 1) != 0 ? plural : singular);
    }
}

