/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.localization;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;

public class Message {
    private static final Collection<Message> messages = new ArrayList<Message>(50);
    private static boolean firstChange = true;
    public final String key;
    private String value;
    private boolean revalidate = true;

    static {
        Language.addListener(new LanguageChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLanguageChange() {
                Iterator iterator = messages.iterator();
                while (iterator.hasNext()) {
                    Message m;
                    Message message = m = (Message)iterator.next();
                    synchronized (message) {
                        m.revalidate = true;
                    }
                    if (!firstChange || !Skript.testing() || Language.english.containsKey(m.key)) continue;
                    Language.missingEntryError(m.key);
                }
                firstChange = false;
            }
        });
    }

    public Message(String key) {
        this.key = key.toLowerCase(Locale.ENGLISH);
        messages.add(this);
        if (Skript.testing() && !Language.english.isEmpty() && !Language.english.containsKey(this.key)) {
            Language.missingEntryError(this.key);
        }
    }

    public String toString() {
        this.validate();
        return this.value == null ? this.key : this.value;
    }

    protected final String getValue() {
        this.validate();
        return this.value;
    }

    public final boolean isSet() {
        this.validate();
        return this.value != null;
    }

    protected synchronized void validate() {
        if (this.revalidate) {
            this.revalidate = false;
            this.value = Language.get_(this.key);
            this.onValueChange();
        }
    }

    protected void onValueChange() {
    }
}

