/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.SingleItemIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.event.Event;

public class VariableString
implements Expression<String> {
    private final String orig;
    private final Object[] string;
    private final boolean isSimple;
    private final String simple;
    private final StringMode mode;
    public static final Map<String, Pattern> variableNames = new HashMap<String, Pattern>();

    private VariableString(String s) {
        this.isSimple = true;
        this.simple = s;
        this.orig = s;
        this.string = null;
        this.mode = StringMode.MESSAGE;
    }

    private VariableString(String orig, Object[] string, StringMode mode) {
        this.orig = orig;
        this.string = string;
        this.mode = mode;
        this.isSimple = false;
        this.simple = null;
    }

    public static VariableString newInstance(String s) {
        return VariableString.newInstance(s, StringMode.MESSAGE);
    }

    public static final boolean isQuotedCorrectly(String s, boolean withQuotes) {
        if (!(!withQuotes || s.startsWith("\"") && s.endsWith("\""))) {
            return false;
        }
        boolean quote = false;
        int i = withQuotes ? 1 : 0;
        while (i < (withQuotes ? s.length() - 1 : s.length())) {
            if (s.charAt(i) != '\"') {
                if (quote) {
                    return false;
                }
            } else {
                quote = !quote;
            }
            ++i;
        }
        return !quote;
    }

    public static VariableString newInstance(String orig, StringMode mode) {
        if (!VariableString.isQuotedCorrectly(orig, false)) {
            return null;
        }
        int n = StringUtils.count(orig, '%');
        if (n % 2 != 0) {
            Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a '%' type it twice: %%.");
            return null;
        }
        String s = Utils.replaceChatStyles(orig.replace("\"\"", "\""));
        ArrayList<Object> string = new ArrayList<Object>(n / 2 + 2);
        int c = s.indexOf(37);
        if (c != -1) {
            if (c != 0) {
                string.add(s.substring(0, c));
            }
            while (c != s.length()) {
                Object last;
                String l;
                int b;
                int c2 = s.indexOf(37, c + 1);
                int a = c;
                while (c2 != -1 && (b = s.indexOf(123, a + 1)) != -1 && b < c2) {
                    a = VariableString.nextVariableBracket(s, b + 1);
                    if (a == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    c2 = s.indexOf(37, a + 1);
                }
                if (c2 == -1) {
                    assert (false);
                    return null;
                }
                if (c + 1 == c2) {
                    if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                        string.set(string.size() - 1, String.valueOf((String)string.get(string.size() - 1)) + "%");
                    } else {
                        string.add("%");
                    }
                } else {
                    RetainingLogHandler log = SkriptLogger.startRetainingLog();
                    try {
                        Expression expr = new SkriptParser(s.substring(c + 1, c2), 1, ParseContext.DEFAULT).parseExpression(Object.class);
                        if (expr == null) {
                            log.printErrors("Can't understand this expression: " + s.substring(c + 1, c2));
                            return null;
                        }
                        if (mode != StringMode.MESSAGE) {
                            string.add(expr);
                        } else {
                            String last2;
                            int l2;
                            ExpressionInfo i = new ExpressionInfo(expr);
                            if (c2 == s.length() - 2 && s.charAt(c2 + 1) == 's' || c2 < s.length() - 2 && s.charAt(c2 + 1) == 's' && Character.isWhitespace(s.charAt(c2 + 2))) {
                                i.flags |= 1;
                            }
                            if (string.size() > 0 && string.get(string.size() - 1) instanceof String && (l2 = last2.lastIndexOf(32, (last2 = (String)string.get(string.size() - 1)).endsWith(" ") ? last2.length() - 1 : last2.length())) != -1) {
                                String lastWord = last2.substring(l2 + 1).trim();
                                if (Noun.isIndefiniteArticle(lastWord)) {
                                    i.flags |= 4;
                                } else if (Noun.isDefiniteArticle(lastWord)) {
                                    i.flags |= 2;
                                }
                                if ((i.flags & 6) != 0) {
                                    string.set(string.size() - 1, last2.substring(0, l2));
                                }
                            }
                            string.add(i);
                        }
                        log.printLog();
                    }
                    finally {
                        log.stop();
                    }
                }
                c = s.indexOf(37, c2 + 1);
                if (c == -1) {
                    c = s.length();
                }
                if ((l = (last = string.get(string.size() - 1)) instanceof ExpressionInfo && (((ExpressionInfo)last).flags & 1) != 0 ? s.substring(c2 + 2, c) : s.substring(c2 + 1, c)).isEmpty()) continue;
                if (string.size() > 0 && string.get(string.size() - 1) instanceof String) {
                    string.set(string.size() - 1, String.valueOf((String)string.get(string.size() - 1)) + l);
                    continue;
                }
                string.add(l);
            }
        } else {
            string.add(s);
        }
        VariableString.checkVariableConflicts(s, mode, string);
        if (string.size() == 1 && string.get(0) instanceof String) {
            return new VariableString((String)string.get(0));
        }
        return new VariableString(orig, string.toArray(), mode);
    }

    private static void checkVariableConflicts(String name, StringMode mode, Iterable<Object> string) {
        Pattern pattern;
        if (mode != StringMode.VARIABLE_NAME || variableNames.containsKey(name)) {
            return;
        }
        if (name.startsWith("%")) {
            Skript.warning("Starting a variable's name with an expression is discouraged ({" + name + "}). You could prefix it with the script's name: {" + StringUtils.substring(ScriptLoader.currentScript.getFileName(), 0, -3) + "." + name + "}");
        }
        if (string != null) {
            StringBuilder p = new StringBuilder();
            block0: for (Object o : string) {
                if (o instanceof Expression) {
                    for (ClassInfo<?> ci : Classes.getClassInfos()) {
                        if (ci.getParser() == null || !ci.getC().isAssignableFrom(((Expression)o).getReturnType())) continue;
                        p.append("(?!%)" + ci.getParser().getVariableNamePattern() + "(?<!%)");
                        continue block0;
                    }
                    p.append("[^%*](.*[^%*])?");
                    continue;
                }
                p.append(Pattern.quote(o.toString()));
            }
            pattern = Pattern.compile(p.toString());
        } else {
            pattern = Pattern.compile(Pattern.quote(name));
        }
        if (!SkriptConfig.disableVariableConflictWarnings.value().booleanValue()) {
            for (Map.Entry<String, Pattern> e : variableNames.entrySet()) {
                if (!e.getValue().matcher(name).matches() && !pattern.matcher(e.getKey()).matches()) continue;
                Skript.warning("Possible name conflict of variables {" + name + "} and {" + e.getKey() + "} (there might be more conflicts).");
                break;
            }
        }
        variableNames.put(name, pattern);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        VariableString.checkVariableConflicts(Utils.replaceChatStyles(this.orig.replace("\"\"", "\"")), this.mode, this.string == null ? null : Arrays.asList(this.string));
    }

    public static int nextVariableBracket(String s, int start) {
        int n = 0;
        int i = start;
        while (i < s.length()) {
            if (s.charAt(i) == '}') {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == '{') {
                ++n;
            }
            ++i;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        int i = 0;
        while (i < args.length) {
            VariableString vs = VariableString.newInstance(args[i]);
            if (vs != null) {
                strings[j++] = vs;
            }
            ++i;
        }
        if (j != args.length) {
            return Arrays.copyOf(strings, j);
        }
        return strings;
    }

    public static VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        int i = 0;
        while (i < args.size()) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString vs = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (vs == null) {
                return null;
            }
            strings[i] = vs;
            ++i;
        }
        return strings;
    }

    public String toString(Event e) {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.string.length) {
            Object o = this.string[i];
            if (o instanceof Expression) {
                assert (this.mode != StringMode.MESSAGE);
                b.append(Classes.toString(((Expression)o).getArray(e), true, this.mode));
            } else if (o instanceof ExpressionInfo) {
                assert (this.mode == StringMode.MESSAGE);
                ExpressionInfo info = (ExpressionInfo)o;
                int flags = info.flags;
                if ((flags & 1) == 0 && b.length() > 0 && Math.abs(StringUtils.numberBefore(b, b.length() - 1)) != 1.0) {
                    flags |= 1;
                }
                b.append(Classes.toString((Object[])info.expr.getArray(e), flags));
            } else {
                b.append(o);
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (this.isSimple) {
            return String.valueOf('\"') + this.simple + '\"';
        }
        StringBuilder b = new StringBuilder("\"");
        Object[] objectArray = this.string;
        int n = this.string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("%").append(((Expression)o).toString(e, debug)).append("%");
            } else if (o instanceof ExpressionInfo) {
                b.append("%").append(((ExpressionInfo)o).expr.toString(e, debug)).append("%");
            } else {
                b.append(o);
            }
            ++n2;
        }
        b.append('\"');
        return b.toString();
    }

    public String getDefaultVariableName() {
        if (this.isSimple) {
            return this.simple;
        }
        StringBuilder b = new StringBuilder();
        Object[] objectArray = this.string;
        int n = this.string.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Expression) {
                b.append("<" + Classes.getSuperClassInfo(((Expression)o).getReturnType()).getCodeName() + ">");
            } else {
                b.append(o);
            }
            ++n2;
        }
        return b.toString();
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    public VariableString setMode(StringMode mode) {
        if (this.mode == mode || this.isSimple) {
            return this;
        }
        BlockingLogHandler h = SkriptLogger.startLogHandler(new BlockingLogHandler());
        try {
            VariableString variableString = VariableString.newInstance(this.orig, mode);
            return variableString;
        }
        finally {
            h.stop();
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSingle(Event e) {
        return this.toString(e);
    }

    public String[] getArray(Event e) {
        return new String[]{this.toString(e)};
    }

    public String[] getAll(Event e) {
        return new String[]{this.toString(e)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean check(Event e, Checker<? super String> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, false);
    }

    @Override
    public boolean check(Event e, Checker<? super String> c) {
        return SimpleExpression.check(this.getAll(e), c, false, false);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        if (to.isAssignableFrom(String.class)) {
            return this;
        }
        return null;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAnd() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Iterator<? extends String> iterator(Event e) {
        return new SingleItemIterator<String>(this.toString(e));
    }

    @Override
    public boolean isLoopOf(String s) {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    public static final <T> Expression<T> setStringMode(Expression<T> e, StringMode mode) {
        VariableString vs;
        if (e instanceof ExpressionList) {
            Expression<T>[] l = ((ExpressionList)e).getExpressions();
            int i = 0;
            while (i < l.length) {
                l[i] = VariableString.setStringMode(l[i], mode);
                ++i;
            }
        } else if (e instanceof VariableString && (vs = ((VariableString)e).setMode(mode)) != null) {
            return vs;
        }
        return e;
    }

    @Override
    public Expression<String> simplify() {
        return this;
    }

    private static final class ExpressionInfo
    implements Serializable {
        final Expression<?> expr;
        int flags = 0;

        ExpressionInfo(Expression<?> expr) {
            this.expr = expr;
        }
    }
}

