/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Checker;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.iterator.EmptyIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.bukkit.event.Event;

public class Variable<T>
implements Expression<T> {
    public static final String SEPARATOR = "::";
    public static final String LOCAL_VARIABLE_TOKEN = "_";
    private final VariableString name;
    private final Class<T> superType;
    private final Class<? extends T>[] types;
    private final boolean local;
    private final boolean list;
    private final Variable<?> source;

    private Variable(VariableString name, Class<? extends T>[] types, boolean local, boolean list, Variable<?> source) {
        assert (name != null);
        assert (types != null && types.length > 0);
        assert (name.isSimple() || name.getMode() == StringMode.VARIABLE_NAME);
        this.local = local;
        this.list = list;
        this.name = name;
        this.types = types;
        this.superType = Utils.getSuperType(types);
        this.source = source;
    }

    public static <T> Variable<T> newInstance(String name, Class<? extends T>[] types) {
        if (name.startsWith(LOCAL_VARIABLE_TOKEN) && name.contains(SEPARATOR)) {
            Skript.error("Local variables cannot be lists, i.e. must not contain the separator '::' (error in variable {" + name + "})");
            return null;
        }
        if (name.startsWith(SEPARATOR) || name.endsWith(SEPARATOR)) {
            Skript.error("A variable's name must neither start nor end with the separator '::' (error in variable {" + name + "})");
            return null;
        }
        if (name.contains("*") && (name.indexOf("*") != name.length() - 1 || !name.endsWith("::*"))) {
            if (name.indexOf("*") == 0) {
                Skript.error("[2.0] Local variables now start with an underscore, e.g. {_local variable} (error in variable {" + name + "})");
            } else {
                Skript.error("A variable's name must not contain any asterisks except at the end after '::' to denote a list variable, e.g. {variable::*} (error in variable {" + name + "})");
            }
            return null;
        }
        if (name.contains("::::")) {
            Skript.error("A variable's name must not contain the separator '::' multiple times in a row (error in variable {" + name + "})");
            return null;
        }
        VariableString vs = VariableString.newInstance(name.startsWith(LOCAL_VARIABLE_TOKEN) ? name.substring(LOCAL_VARIABLE_TOKEN.length()) : name, StringMode.VARIABLE_NAME);
        if (vs == null) {
            return null;
        }
        return new Variable<T>(vs, types, name.startsWith(LOCAL_VARIABLE_TOKEN), name.endsWith("::*"), null);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSingle() {
        return !this.list;
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    @Override
    public String toString(Event e, boolean debug) {
        if (e != null) {
            return Classes.toString(this.get(e));
        }
        return "{" + (this.local ? LOCAL_VARIABLE_TOKEN : "") + StringUtils.substring(this.name.toString(e, debug), 1, -1) + "}" + (debug ? "(as " + this.superType.getName() + ")" : "");
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> to) {
        return new Variable<T>(this.name, new Class[]{to}, this.local, this.list, this);
    }

    private Object getRaw(Event e) {
        assert (!this.local);
        Object val = Variables.getVariable(this.name.toString(e).toLowerCase(Locale.ENGLISH));
        if (val == null) {
            return Variables.getVariable(this.name.getDefaultVariableName().toLowerCase(Locale.ENGLISH));
        }
        return val;
    }

    private Object get(Event e) {
        if (this.local) {
            return Variables.getLocalVariable(this.name.toString(e).toLowerCase(Locale.ENGLISH), e);
        }
        Object val = this.getRaw(e);
        if (!this.list) {
            return val;
        }
        if (val == null) {
            return Array.newInstance(this.types[0], 0);
        }
        ArrayList l = new ArrayList();
        for (Map.Entry v : ((Map)val).entrySet()) {
            if (v.getKey() == null || v.getValue() == null) continue;
            if (v.getValue() instanceof Map) {
                l.add(((Map)v.getValue()).get(null));
                continue;
            }
            l.add(v.getValue());
        }
        return l.toArray((Object[])Array.newInstance(this.superType, l.size()));
    }

    public Iterator<Pair<String, Object>> variablesIterator(Event e) {
        if (!this.list) {
            throw new SkriptAPIException("");
        }
        final String name = StringUtils.substring(this.name.toString(e), 0, -1).toLowerCase(Locale.ENGLISH);
        Object val = Variables.getVariable(String.valueOf(name) + "*");
        if (val == null) {
            return new EmptyIterator<Pair<String, Object>>();
        }
        assert (val instanceof TreeMap);
        final Iterator keys = new ArrayList(((Map)val).keySet()).iterator();
        return new Iterator<Pair<String, Object>>(){
            private String key;
            private Object next = null;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.next == null) ** GOTO lbl8
                return true;
lbl-1000:
                // 1 sources

                {
                    this.key = (String)keys.next();
                    if (this.key == null) continue;
                    this.next = Variables.getVariable(String.valueOf(name) + this.key);
                    if (this.next == null || this.next instanceof TreeMap) continue;
                    return true;
lbl8:
                    // 3 sources

                    ** while (keys.hasNext())
                }
lbl9:
                // 1 sources

                this.next = null;
                return false;
            }

            @Override
            public Pair<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Pair<String, Object> n = new Pair<String, Object>(this.key, this.next);
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<T> iterator(Event e) {
        if (!this.list) {
            throw new SkriptAPIException("");
        }
        final String name = StringUtils.substring(this.name.toString(e), 0, -1).toLowerCase(Locale.ENGLISH);
        Object val = Variables.getVariable(String.valueOf(name) + "*");
        if (val == null) {
            return new EmptyIterator();
        }
        assert (val instanceof TreeMap);
        final Iterator keys = new ArrayList(((Map)val).keySet()).iterator();
        return new Iterator<T>(){
            private String key;
            private T next = null;

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.next == null) ** GOTO lbl8
                return true;
lbl-1000:
                // 1 sources

                {
                    this.key = (String)keys.next();
                    if (this.key == null) continue;
                    this.next = Converters.convert(Variables.getVariable(String.valueOf(name) + this.key), Variable.access$0(Variable.this));
                    if (this.next == null || this.next instanceof TreeMap) continue;
                    return true;
lbl8:
                    // 3 sources

                    ** while (keys.hasNext())
                }
lbl9:
                // 1 sources

                this.next = null;
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object n = this.next;
                this.next = null;
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private T getConverted(Event e) {
        assert (!this.list);
        return Converters.convert(this.get(e), this.types);
    }

    private T[] getConvertedArray(Event e) {
        assert (this.list);
        return Converters.convertArray((Object[])this.get(e), this.types, this.superType);
    }

    private final void set(Event e, Object value) {
        if (this.local) {
            Variables.setLocalVariable(this.name.toString(e).toLowerCase(Locale.ENGLISH), e, value);
        } else {
            Variables.setVariable(this.name.toString(e).toLowerCase(Locale.ENGLISH), value);
        }
    }

    private final void setIndex(Event e, String index, Object value) {
        assert (this.list);
        String s = this.name.toString(e).toLowerCase(Locale.ENGLISH);
        Variables.setVariable(String.valueOf(s.substring(0, s.length() - 1)) + index.toLowerCase(Locale.ENGLISH), value);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.list) {
            return CollectionUtils.array(Object[].class);
        }
        return CollectionUtils.array(Object.class);
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        switch (mode) {
            case DELETE: {
                this.set(e, null);
                break;
            }
            case SET: {
                if (this.list) {
                    this.set(e, null);
                    int i = 1;
                    Object[] objectArray = (Object[])delta;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object instanceof Object[]) {
                            int j = 0;
                            while (j < ((Object[])object).length) {
                                this.setIndex(e, i + SEPARATOR + j, ((Object[])object)[j]);
                                ++j;
                            }
                        } else {
                            this.setIndex(e, "" + i, object);
                        }
                        ++i;
                        ++n2;
                    }
                    break;
                }
                this.set(e, delta);
                break;
            }
            case RESET: {
                Object x = this.getRaw(e);
                for (Object v : x instanceof Map ? ((Map)x).values() : Arrays.asList(x)) {
                    ClassInfo<?> ci = Classes.getSuperClassInfo(v.getClass());
                    if (ci.getChanger() == null || ci.getChanger().acceptChange(Changer.ChangeMode.RESET) == null) continue;
                    Object[] one = (Object[])Array.newInstance(v.getClass(), 1);
                    one[0] = v;
                    ci.getChanger().change(one, null, Changer.ChangeMode.RESET);
                }
                break;
            }
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: {
                if (delta == null) break;
                if (this.list) {
                    Object[] objectArray = (Object[])delta;
                    Map o = (Map)this.getRaw(e);
                    if (mode == Changer.ChangeMode.REMOVE) {
                        if (o == null) {
                            return;
                        }
                        ArrayList<String> rem = new ArrayList<String>();
                        Object[] objectArray2 = objectArray;
                        int n = objectArray.length;
                        int j = 0;
                        while (j < n) {
                            Object d = objectArray2[j];
                            for (Map.Entry i : o.entrySet()) {
                                if (!Comparator.Relation.EQUAL.is(Comparators.compare(i.getValue(), d))) continue;
                                rem.add((String)i.getKey());
                                break;
                            }
                            ++j;
                        }
                        for (String r : rem) {
                            this.setIndex(e, r, null);
                        }
                    } else if (mode == Changer.ChangeMode.REMOVE_ALL) {
                        if (o == null) {
                            return;
                        }
                        ArrayList<String> rem = new ArrayList<String>();
                        for (Map.Entry i : o.entrySet()) {
                            Object[] objectArray3 = objectArray;
                            int n = objectArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Object d = objectArray3[n3];
                                if (Comparator.Relation.EQUAL.is(Comparators.compare(i.getValue(), d))) {
                                    rem.add((String)i.getKey());
                                }
                                ++n3;
                            }
                        }
                        for (String r : rem) {
                            this.setIndex(e, r, null);
                        }
                    } else {
                        int i = 1;
                        Object[] objectArray4 = objectArray;
                        int d = objectArray.length;
                        int j = 0;
                        while (j < d) {
                            Object d2 = objectArray4[j];
                            if (o != null) {
                                while (o.containsKey("" + i)) {
                                    ++i;
                                }
                            }
                            this.setIndex(e, "" + i, d2);
                            ++i;
                            ++j;
                        }
                    }
                } else {
                    Class c;
                    ClassInfo<?> ci;
                    Object object = this.get(e);
                    Number n = null;
                    if ((object == null || object instanceof Number) && (delta instanceof Number || (n = Converters.convert(delta, Number.class)) != null)) {
                        int i = mode == Changer.ChangeMode.ADD ? 1 : -1;
                        this.set(e, (object == null ? 0.0 : ((Number)object).doubleValue()) + (double)i * (n != null ? (Number)n : (Number)((Number)delta)).doubleValue());
                        break;
                    }
                    if (object == null || (ci = Classes.getSuperClassInfo(object.getClass())).getChanger() == null || ci.getChanger().acceptChange(mode) == null) break;
                    Class<V>[] cs = ci.getChanger().acceptChange(mode);
                    Object[] one = (Object[])Array.newInstance(object.getClass(), 1);
                    one[0] = object;
                    Class<V>[] classArray = cs;
                    int n4 = cs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        c = classArray[n5];
                        if (c.isInstance(delta)) {
                            Changer.ChangerUtils.change(ci.getChanger(), one, delta, mode);
                            return;
                        }
                        if (c.isArray() && c.getComponentType().isInstance(delta)) {
                            Object[] deltas = (Object[])Array.newInstance(c.getComponentType(), 1);
                            deltas[0] = delta;
                            Changer.ChangerUtils.change(ci.getChanger(), one, deltas, mode);
                            return;
                        }
                        ++n5;
                    }
                    classArray = cs;
                    n4 = cs.length;
                    n5 = 0;
                    while (n5 < n4) {
                        Object d;
                        c = classArray[n5];
                        if (delta instanceof Object[]) {
                            if (c.isArray() && (d = Converters.convertArray((Object[])delta, c.getComponentType())) != null) {
                                Changer.ChangerUtils.change(ci.getChanger(), one, d, mode);
                                return;
                            }
                        } else {
                            d = Converters.convert(delta, c.isArray() ? c.getComponentType() : c);
                            if (d != null) {
                                if (c.isArray()) {
                                    Object[] deltas = (Object[])Array.newInstance(c.getComponentType(), 1);
                                    deltas[0] = d;
                                    Changer.ChangerUtils.change(ci.getChanger(), one, deltas, mode);
                                } else {
                                    Changer.ChangerUtils.change(ci.getChanger(), one, d, mode);
                                }
                                return;
                            }
                        }
                        ++n5;
                    }
                }
                break;
            }
        }
    }

    @Override
    public T getSingle(Event e) {
        if (this.list) {
            throw new SkriptAPIException("Invalid call to getSingle");
        }
        return this.getConverted(e);
    }

    @Override
    public T[] getArray(Event e) {
        return this.getAll(e);
    }

    @Override
    public T[] getAll(Event e) {
        if (this.list) {
            return this.getConvertedArray(e);
        }
        T o = this.getConverted(e);
        if (o == null) {
            return (Object[])Array.newInstance(this.superType, 0);
        }
        Object[] one = (Object[])Array.newInstance(this.superType, 1);
        one[0] = o;
        return one;
    }

    @Override
    public boolean isLoopOf(String s) {
        return s.equalsIgnoreCase("var") || s.equalsIgnoreCase("variable") || s.equalsIgnoreCase("value") || s.equalsIgnoreCase("index");
    }

    public boolean isIndexLoop(String s) {
        return s.equalsIgnoreCase("index");
    }

    @Override
    public boolean check(Event e, Checker<? super T> c, boolean negated) {
        return SimpleExpression.check(this.getAll(e), c, negated, this.getAnd());
    }

    @Override
    public boolean check(Event e, Checker<? super T> c) {
        return SimpleExpression.check(this.getAll(e), c, false, this.getAnd());
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    @Override
    public Expression<? extends T> simplify() {
        return this;
    }

    static /* synthetic */ Class[] access$0(Variable variable) {
        return variable.types;
    }
}

