/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Checker;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.iterator.NonNullIterator;
import java.util.logging.Level;
import org.bukkit.event.Event;

public class UnparsedLiteral
implements Literal<Object> {
    private final String data;
    private final LogEntry error;

    public UnparsedLiteral(String data) {
        assert (data != null && data.length() > 0);
        this.data = data;
        this.error = null;
    }

    public UnparsedLiteral(String data, LogEntry error) {
        assert (data != null && data.length() > 0);
        assert (error == null || error.getLevel() == Level.SEVERE);
        this.data = data;
        this.error = error;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    @Override
    public <R> Literal<? extends R> getConvertedExpression(Class<R> to) {
        return this.getConvertedExpression(ParseContext.DEFAULT, to);
    }

    public <R> Literal<? extends R> getConvertedExpression(ParseContext context, Class<? extends R> ... to) {
        assert (to != null && to.length > 0);
        assert (to.length == 1 || !CollectionUtils.contains(to, Object.class));
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Class<? extends R>[] classArray = to;
            int n = to.length;
            int n2 = 0;
            while (n2 < n) {
                Class<R> t = classArray[n2];
                R r = Classes.parse(this.data, t, context);
                if (r != null) {
                    log.printLog();
                    SimpleLiteral<R> simpleLiteral = new SimpleLiteral<R>(r, false);
                    return simpleLiteral;
                }
                log.clear();
                ++n2;
            }
            if (this.error != null) {
                log.printLog();
                SkriptLogger.log(this.error);
            } else {
                log.printError();
            }
            return null;
        }
        finally {
            log.stop();
        }
    }

    @Override
    public String toString(Event e, boolean debug) {
        return "'" + this.data + "'";
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Expression<? extends Object> simplify() {
        return this;
    }

    private static final SkriptAPIException invalidAccessException() {
        return new SkriptAPIException("UnparsedLiterals must be converted before use");
    }

    @Override
    public Object[] getAll() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getAll(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getArray() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object[] getArray(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object getSingle() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Object getSingle(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public NonNullIterator<Object> iterator(Event e) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public void change(Event e, Object delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean check(Event e, Checker<? super Object> c) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean check(Event e, Checker<? super Object> c, boolean negated) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean setTime(int time) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public int getTime() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean isDefault() {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean isLoopOf(String s) {
        throw UnparsedLiteral.invalidAccessException();
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw UnparsedLiteral.invalidAccessException();
    }
}

