/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.util.StringUtils;
import java.io.Serializable;
import org.bukkit.event.Event;

public abstract class TriggerItem
implements Debuggable,
Serializable {
    protected TriggerSection parent = null;
    private TriggerItem next = null;
    private static final String indent = "  ";
    private String indentation = null;

    protected TriggerItem() {
    }

    protected TriggerItem(TriggerSection parent) {
        this.parent = parent;
    }

    protected TriggerItem walk(Event e) {
        if (this.run(e)) {
            this.debug(e, true);
            return this.next;
        }
        this.debug(e, false);
        return this.parent == null ? null : this.parent.getNext();
    }

    protected abstract boolean run(Event var1);

    public static final boolean walk(TriggerItem start, Event e) {
        block6: {
            assert (start != null && e != null);
            TriggerItem i = start;
            try {
                while (i != null) {
                    i = i.walk(e);
                }
                return true;
            }
            catch (StackOverflowError err) {
                Skript.adminBroadcast("<red>The script '<gold>" + start.getTrigger().getScript().getName() + "<red>' infinitely repeated itself!");
                if (Skript.debug()) {
                    err.printStackTrace();
                }
            }
            catch (Exception ex) {
                if (ex.getStackTrace().length == 0) break block6;
                Skript.exception((Throwable)ex, i, new String[0]);
            }
        }
        return false;
    }

    protected String getIndentation() {
        if (this.indentation == null) {
            int level = 0;
            TriggerItem i = this;
            while ((i = i.parent) != null) {
                ++level;
            }
            this.indentation = StringUtils.multiply(indent, level);
        }
        return this.indentation;
    }

    protected final void debug(Event e, boolean run) {
        if (!Skript.debug()) {
            return;
        }
        Skript.debug(String.valueOf(this.getIndentation()) + (run ? "" : "-") + this.toString(e, true));
    }

    @Override
    public final String toString() {
        return this.toString(null, false);
    }

    public void setParent(TriggerSection parent) {
        this.parent = parent;
    }

    public final TriggerSection getParent() {
        return this.parent;
    }

    public final Trigger getTrigger() {
        TriggerItem i = this;
        while (i != null && !(i instanceof Trigger)) {
            i = i.getParent();
        }
        if (i == null) {
            throw new IllegalStateException("TriggerItem without a Trigger detected!");
        }
        return (Trigger)i;
    }

    public void setNext(TriggerItem next) {
        this.next = next;
    }

    public TriggerItem getNext() {
        return this.next;
    }
}

