/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Utils;
import ch.njol.util.CollectionUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.inventory.ItemStack;

public class SkriptParser {
    private final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    public static final int ALL_FLAGS = 3;
    private final int flags;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}", 2);
    public static final Pattern listSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    private static final String MULTIPLE_AND_OR = "List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists.";
    private static final String MISSING_AND_OR = "List is missing 'and' or 'or', defaulting to 'and'";
    private static final Message m_quotes_error = new Message("skript.quotes error");
    private static final Message m_brackets_error = new Message("skript.brackets error");

    public SkriptParser(String expr) {
        this(expr, 3);
    }

    public SkriptParser(String expr, int flags) {
        this(expr, flags, ParseContext.DEFAULT);
    }

    public SkriptParser(String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert ((flags & 3) != 0);
        this.expr = expr.trim();
        this.flags = flags;
        this.context = context;
    }

    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        if ((expr = expr.trim()).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    public static final <T extends SyntaxElement> T parse(String expr, Iterator<? extends SyntaxElementInfo<T>> source, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            return null;
        }
        finally {
            log.stop();
        }
    }

    public static final <T extends SyntaxElement> T parseStatic(String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            Skript.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            T e = new SkriptParser(expr, 2).parse(source);
            if (e != null) {
                log.printLog();
                T t = e;
                return t;
            }
            log.printError(defaultError);
            return null;
        }
        finally {
            log.stop();
        }
    }

    /*
     * Exception decompiling
     */
    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final <T> Variable<T> parseVariable(String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            return Variable.newInstance(expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), returnTypes);
        }
        return null;
    }

    public final <T> Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        assert (types != null && types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (types.length == 1 && types[0] == Object.class) {
            return this.parseObjectExpression();
        }
        LinkedList<Expression<? extends T>> ts = new LinkedList<Expression<? extends T>>();
        Kleenean and = Kleenean.UNKNOWN;
        boolean isLiteralList = true;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            Expression<? extends T> r = this.parseSingleExpr(types);
            if (r != null) {
                log.printLog();
                Expression<? extends T> expression = r;
                return expression;
            }
            log.clear();
            Matcher m = listSplitPattern.matcher(this.expr);
            String lastExpr = this.expr;
            int end = this.expr.length();
            int expectedEnd = -1;
            boolean last = false;
            while (m.find() || (last = !last)) {
                Expression<? extends T> t;
                int start;
                if (expectedEnd == -1) {
                    if (last) break;
                    expectedEnd = m.start();
                }
                int n = start = last ? 0 : m.end();
                if (this.context != ParseContext.COMMAND && (start < this.expr.length() && this.expr.charAt(start) == '(' || end - 1 > 0 && this.expr.charAt(end - 1) == ')')) {
                    if (start < this.expr.length() && this.expr.charAt(start) == '(' && end - 1 > 0 && this.expr.charAt(end - 1) == ')' && SkriptParser.next(this.expr, start, this.context) == end) {
                        lastExpr = this.expr.substring(start + 1, end - 1);
                        t = new SkriptParser(lastExpr, this.flags, this.context).parseExpression(types);
                    } else {
                        t = null;
                    }
                } else {
                    lastExpr = this.expr.substring(start, end);
                    t = new SkriptParser(lastExpr, this.flags, this.context).parseSingleExpr(types);
                }
                if (t != null) {
                    isLiteralList &= t instanceof Literal;
                    if (!last && m.group(1) != null) {
                        if (and.isUnknown()) {
                            and = Kleenean.get(m.group(1).equalsIgnoreCase("and"));
                        } else if (and != Kleenean.get(m.group(1).equalsIgnoreCase("and"))) {
                            Skript.warning(MULTIPLE_AND_OR);
                            and = Kleenean.TRUE;
                        }
                    }
                    ts.addFirst(t);
                    if (last) break;
                    end = m.start();
                    m.region(0, end);
                    continue;
                }
                log.clear();
                if (!last) continue;
                end = -2;
            }
            if (end != expectedEnd) {
                log.printError("'" + lastExpr + "' is " + SkriptParser.notOfType(types));
                return null;
            }
            log.printLog();
            if (ts.size() == 1) {
                Expression expression = (Expression)ts.getFirst();
                return expression;
            }
            if (and.isUnknown()) {
                Skript.warning(MISSING_AND_OR);
            }
            if (isLiteralList) {
                LiteralList literalList = new LiteralList(ts.toArray(new Literal[ts.size()]), Utils.getSuperType(types), !and.isFalse());
                return literalList;
            }
            ExpressionList expressionList = new ExpressionList(ts.toArray(new Expression[ts.size()]), Utils.getSuperType(types), !and.isFalse());
            return expressionList;
        }
        finally {
            log.stop();
        }
    }

    private final Expression<?> parseObjectExpression() {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            if ((this.flags & 1) != 0) {
                Expression r = new SkriptParser(this.expr, 1, this.context).parseSingleExpr(Object.class);
                if (r != null) {
                    log.printLog();
                    Expression expression = r;
                    return expression;
                }
                if ((this.flags & 2) == 0) {
                    log.printError();
                    return null;
                }
                log.clear();
            }
            if ((this.flags & 2) != 0) {
                SkriptParser p = new SkriptParser(this.expr, 2, this.context);
                Class[] classArray = new Class[]{Number.class, Time.class, ItemType.class, ItemStack.class};
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c = classArray[n2];
                    Expression e = p.parseExpression(c);
                    if (e != null) {
                        log.printLog();
                        Expression expression = e;
                        return expression;
                    }
                    log.clear();
                    ++n2;
                }
            }
        }
        finally {
            log.printLog();
        }
        Matcher m = listSplitPattern.matcher(this.expr);
        if (!m.find()) {
            return new UnparsedLiteral(this.expr, log.getError());
        }
        m.reset();
        ArrayList ts = new ArrayList();
        Kleenean and = Kleenean.UNKNOWN;
        boolean last = false;
        boolean isLiteralList = true;
        int start = 0;
        while (!last) {
            Expression<Object> t;
            if (this.context != ParseContext.COMMAND && this.expr.charAt(start) == '(') {
                int end = SkriptParser.next(this.expr, start, this.context);
                if (end == -1) {
                    return null;
                }
                boolean bl = last = end == this.expr.length();
                if (!last) {
                    m.region(end, this.expr.length());
                    if (!m.lookingAt()) {
                        return null;
                    }
                }
                t = new SkriptParser(this.expr.substring(start + 1, end - 1), this.flags, this.context).parseObjectExpression();
            } else {
                m.region(start, this.expr.length());
                last = !m.find();
                String sub = last ? this.expr.substring(start) : this.expr.substring(start, m.start());
                t = new SkriptParser(sub, this.flags, this.context).parseSingleExpr(Object.class);
            }
            if (t == null) {
                return null;
            }
            if (!last) {
                start = m.end();
            }
            isLiteralList &= t instanceof Literal;
            if (!last && m.group(1) != null) {
                if (and.isUnknown()) {
                    and = Kleenean.get(m.group(1).equalsIgnoreCase("and"));
                } else if (and != Kleenean.get(m.group(1).equalsIgnoreCase("and"))) {
                    Skript.warning(MULTIPLE_AND_OR);
                    and = Kleenean.TRUE;
                }
            }
            ts.add(t);
        }
        assert (ts.size() > 1);
        if (and.isUnknown()) {
            Skript.warning(MISSING_AND_OR);
        }
        if (isLiteralList) {
            return new LiteralList<Object>(ts.toArray(new Literal[ts.size()]), Object.class, !and.isFalse());
        }
        return new ExpressionList<Object>(ts.toArray(new Expression[ts.size()]), Object.class, !and.isFalse());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> Expression<? extends T> parseSingleExpr(Class<? extends T> ... types) {
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this.expr.substring(1, this.expr.length() - 1), this.flags, this.context).parseSingleExpr(types);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        try {
            void var5_20;
            Variable<? extends T> var = SkriptParser.parseVariable(this.expr, types);
            if (var != null) {
                if ((this.flags & 1) == 0) {
                    Skript.error("Variables cannot be used here.");
                    log.printError();
                    return null;
                }
                log.printLog();
                Variable<? extends T> variable = var;
                return variable;
            }
            if (log.hasError()) {
                log.printError(null);
                return null;
            }
            log.clear();
            if ((this.flags & 1) != 0) {
                Expression<String> e = this.expr.startsWith("\"") && this.expr.endsWith("\"") && (types[0] == Object.class || CollectionUtils.contains(types, String.class)) ? VariableString.newInstance(this.expr.substring(1, this.expr.length() - 1)) : (Expression<String>)SkriptParser.parse(this.expr, Skript.getExpressions(types), null);
                if (e != null) {
                    Class<? extends T>[] classArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<T> clazz = classArray[n2];
                        if (clazz.isAssignableFrom(e.getReturnType())) {
                            log.printLog();
                            Expression<String> expression = e;
                            return expression;
                        }
                        ++n2;
                    }
                    classArray = types;
                    n = types.length;
                    n2 = 0;
                    while (n2 < n) {
                        Class<? extends T> clazz = classArray[n2];
                        Expression<? extends T> r = e.getConvertedExpression(clazz);
                        if (r != null) {
                            log.printLog();
                            Expression<? extends T> expression = r;
                            return expression;
                        }
                        ++n2;
                    }
                    log.error(String.valueOf(e.toString(null, false)) + " is " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                    log.printError(null);
                    return null;
                }
                log.clear();
            }
            if ((this.flags & 2) == 0) {
                log.printError(null);
                return null;
            }
            if (types[0] == Object.class) {
                log.clear();
                log.printLog();
                UnparsedLiteral unparsedLiteral = new UnparsedLiteral(this.expr);
                return unparsedLiteral;
            }
            Class<? extends T>[] classArray = types;
            int n = types.length;
            boolean bl = false;
            while (var5_20 < n) {
                Class<? extends T> c = classArray[var5_20];
                log.clear();
                T t = Classes.parse(this.expr, c, this.context);
                if (t != null) {
                    log.printLog();
                    SimpleLiteral<T> simpleLiteral = new SimpleLiteral<T>(t, false);
                    return simpleLiteral;
                }
                ++var5_20;
            }
            log.printError();
            return null;
        }
        finally {
            log.stop();
        }
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(args, 2, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        int i = 0;
        while (i < res.exprs.length) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
            } else {
                as.get(i).set(event, res.exprs[i].getArray(event));
            }
            ++i;
        }
        return true;
    }

    public static ParseResult parse(String text, String pattern) {
        return new SkriptParser(text, 2, ParseContext.COMMAND).parse_i(pattern, 0, 0);
    }

    public static Pair<SkriptEventInfo<?>, SkriptEvent> parseEvent(String event, String defaultError) {
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        try {
            Pair<SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(event, 2, ParseContext.EVENT).parseEvent();
            if (e != null) {
                log.printLog();
                Pair<SkriptEventInfo<?>, SkriptEvent> pair = e;
                return pair;
            }
            log.printErrors(defaultError);
            return null;
        }
        finally {
            log.stop();
        }
    }

    /*
     * Unable to fully structure code
     */
    private Pair<SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        if (!SkriptParser.$assertionsDisabled && this.context != ParseContext.EVENT) {
            throw new AssertionError();
        }
        if (!SkriptParser.$assertionsDisabled && this.flags != 2) {
            throw new AssertionError();
        }
        log = SkriptLogger.startParseLogHandler();
        try {
            for (SkriptEventInfo<?> info : Skript.getEvents()) {
                i = 0;
                while (i < info.patterns.length) {
                    log.clear();
                    try {
                        res = this.parse_i(info.patterns[i], 0, 0);
                        if (res != null) {
                            e = (SkriptEvent)info.c.newInstance();
                            if (!e.init((Literal[])Arrays.copyOf(res.exprs, res.exprs.length, Literal[].class), i, res)) {
                                log.printError();
                                return null;
                            }
                            log.printLog();
                            var8_9 = new Pair<SkriptEventInfo<?>, SkriptEvent>(info, e);
                            return var8_9;
                        }
                    }
                    catch (InstantiationException e) {
                        if (!SkriptParser.$assertionsDisabled) {
                            throw new AssertionError();
                        }
                    }
                    catch (IllegalAccessException e) {
                        if (SkriptParser.$assertionsDisabled) ** GOTO lbl-1000
                        throw new AssertionError();
                    }
lbl-1000:
                    // 3 sources

                    {
                        ++i;
                    }
                }
            }
        }
        finally {
            log.stop();
        }
        log.printError(null);
        return null;
    }

    private static int nextBracket(String pattern, char closingBracket, char openingBracket, int start) throws MalformedPatternException {
        int n = 0;
        int i = start;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (pattern.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        int i = from;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int countUnescaped(String pattern, char c) {
        int r = 0;
        int i = 0;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    public static final String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + Classes.getSuperClassInfo(cs[0]).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(Classes.getSuperClassInfo(cs[k]).getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static final String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    private static final int next(String expr, int i, ParseContext context) {
        if (i >= expr.length()) {
            return -1;
        }
        if (context == ParseContext.COMMAND) {
            return i + 1;
        }
        if (expr.charAt(i) == '\"') {
            int i2 = SkriptParser.nextQuote(expr, i + 1) + 1;
            return i2 == 0 ? -1 : i2;
        }
        if (expr.charAt(i) == '{') {
            int i2 = VariableString.nextVariableBracket(expr, i + 1) + 1;
            return i2 == 0 ? -1 : i2;
        }
        if (expr.charAt(i) == '(') {
            int j = i + 1;
            while (j != -1 && j < expr.length()) {
                if (expr.charAt(j) == ')') {
                    return j + 1;
                }
                j = SkriptParser.next(expr, j, context);
            }
            return -1;
        }
        return i + 1;
    }

    /*
     * Exception decompiling
     */
    private final ParseResult parse_i(String pattern, int i, int j) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 6[TRYBLOCK]], but top level block is 40[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final Pair<String, boolean[]> validatePattern(String pattern) {
        ArrayList<Boolean> ps = new ArrayList<Boolean>();
        int groupLevel = 0;
        int optionalLevel = 0;
        LinkedList<Character> groups = new LinkedList<Character>();
        StringBuilder b = new StringBuilder(pattern.length());
        int last = 0;
        int i = 0;
        while (i < pattern.length()) {
            int j;
            char c = pattern.charAt(i);
            if (c == '(') {
                ++groupLevel;
                groups.addLast(Character.valueOf(c));
            } else if (c == '|') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(') {
                    return SkriptParser.error("Cannot use the pipe character '|' outside of groups");
                }
            } else if (c == ')') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(') {
                    return SkriptParser.error("Unexpected closing group bracket ')'");
                }
                --groupLevel;
                groups.removeLast();
            } else if (c == '[') {
                ++optionalLevel;
                groups.addLast(Character.valueOf(c));
            } else if (c == ']') {
                if (optionalLevel == 0 || ((Character)groups.peekLast()).charValue() != '[') {
                    return SkriptParser.error("Unexpected closing optional bracket ']'");
                }
                --optionalLevel;
                groups.removeLast();
            } else if (c == '<') {
                j = pattern.indexOf(62, i + 1);
                if (j == -1) {
                    return SkriptParser.error("Missing closing regex bracket '>'");
                }
                try {
                    Pattern.compile(pattern.substring(i + 1, j));
                }
                catch (PatternSyntaxException e) {
                    return SkriptParser.error("Invalid regex '" + pattern.substring(i + 1, j) + "': " + e.getLocalizedMessage());
                }
                i = j;
            } else {
                if (c == '>') {
                    return SkriptParser.error("Unexpected closing regex bracket '>'");
                }
                if (c == '%') {
                    j = pattern.indexOf(37, i + 1);
                    if (j == -1) {
                        return SkriptParser.error("Missing end sign '%' of expression");
                    }
                    Pair<String, Boolean> p = Utils.getEnglishPlural(pattern.substring(i + 1, j));
                    ClassInfo<?> ci = Classes.getClassInfoFromUserInput((String)p.first);
                    if (ci == null) {
                        return SkriptParser.error("The type '" + (String)p.first + "' could not be found");
                    }
                    ps.add((Boolean)p.second);
                    b.append(pattern.substring(last, i + 1));
                    b.append(Utils.toEnglishPlural(ci.getCodeName(), (Boolean)p.second));
                    last = j;
                    i = j;
                } else if (c == '\\') {
                    if (i == pattern.length() - 1) {
                        return SkriptParser.error("Pattern must not end in a backslash");
                    }
                    ++i;
                }
            }
            ++i;
        }
        b.append(pattern.substring(last));
        boolean[] plurals = new boolean[ps.size()];
        int i2 = 0;
        while (i2 < plurals.length) {
            plurals[i2] = (Boolean)ps.get(i2);
            ++i2;
        }
        return new Pair<String, boolean[]>(b.toString(), plurals);
    }

    private static final Pair<String, boolean[]> error(String error) {
        Skript.error("Invalid pattern: " + error);
        return null;
    }

    public static final boolean validateLine(String line) {
        if (StringUtils.count(line, '\"') % 2 != 0) {
            Skript.error(m_quotes_error.toString());
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            if (i == -1) {
                Skript.error(m_brackets_error.toString());
                return false;
            }
            i = SkriptParser.next(line, i, ParseContext.DEFAULT);
        }
        return true;
    }

    private static ExprInfo getExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        int a;
        ExprInfo r = new ExprInfo();
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = s.substring(1);
        }
        if (s.startsWith("*")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFD;
        }
        if (!r.isOptional) {
            r.isOptional = s.startsWith("-");
            if (r.isOptional) {
                s = s.substring(1);
            }
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = s.substring(0, a);
        }
        String[] classes = s.split("/");
        r.classes = new ClassInfo[classes.length];
        r.isPlural = new boolean[classes.length];
        int i = 0;
        while (i < classes.length) {
            Pair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            r.classes[i] = Classes.getClassInfo((String)p.first);
            r.isPlural[i] = (Boolean)p.second;
            ++i;
        }
        return r;
    }

    private static final class ExprInfo {
        ClassInfo<?>[] classes;
        boolean[] isPlural;
        boolean isOptional;
        int flagMask = -1;
        int time = 0;

        private ExprInfo() {
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        public MalformedPatternException(String pattern, String message) {
            this(message, pattern, null);
        }

        public MalformedPatternException(String pattern, String message, Throwable cause) {
            super(String.valueOf(message) + " [pattern: " + pattern + "]", cause);
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>();
        public final String expr;
        public int mark = -1;

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }
    }
}

